% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_lmm_tune.R
\name{cat_lmm_tune}
\alias{cat_lmm_tune}
\title{Catalytic Linear Mixed Model (LMM) Fitting Function by Tuning tau from a Sequence of tau Values}
\usage{
cat_lmm_tune(cat_init, tau_seq = NULL, cross_validation_fold_num = 5)
}
\arguments{
\item{cat_init}{A list generated from \code{cat_lmm_initialization}.}

\item{tau_seq}{A numeric vector specifying the sequence of tau values to be tested.
If NULL, a default sequence is generated based on the number of predictors.}

\item{cross_validation_fold_num}{An integer representing the number of folds for cross-validation.
Defaults to 5.}
}
\value{
A list containing the values of all the arguments and the following components:
\item{tau}{The optimal tau value determined from cross-validation.}
\item{model}{The fitted lmer model object by using the optimal tau value.}
\item{coefficients}{Coefficients of the fitted model by using the optimal tau value.}
\item{risk_estimate_list}{Average prediction errors for each tau value.}
}
\description{
This function tunes a catalytic linear mixed model by performing cross-validation
to estimate the optimal value of the tuning parameter tau. It finally uses the optimal tau value
in the \code{lmer} function from the \code{lme4} package for model fitting. (Only consider one random effect variance)
}
\examples{
data(mtcars)
cat_init <- cat_lmm_initialization(
  formula = mpg ~ wt + (1 | cyl), # formula for simple model
  data = mtcars,
  x_cols = c("wt"), # Fixed effects
  y_col = "mpg", # Response variable
  z_cols = c("disp", "hp", "drat", "qsec", "vs", "am", "gear", "carb"), # Random effects
  group_col = "cyl", # Grouping column
  syn_size = 100, # Synthetic data size
  resample_by_group = FALSE, # Resampling option
  resample_only = FALSE, # Resampling method
  na_replace = mean # NA replacement method
)

cat_model <- cat_lmm_tune(
  cat_init = cat_init, # Only accept object generated from cat_lmm_initialization
  tau_seq = c(1, 2), # Vector of weights for synthetic data
  cross_validation_fold_num = 3 # number of folds for cross-validation
)
cat_model

}
