% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{hmc_neal_2010}
\alias{hmc_neal_2010}
\title{Hamiltonian Monte Carlo (HMC) Implementation}
\usage{
hmc_neal_2010(
  neg_log_den_func,
  neg_log_den_grad_func,
  leapfrog_stepsize,
  leapfrog_step,
  current_pos
)
}
\arguments{
\item{neg_log_den_func}{A function that evaluates the negative log of the density
(potential energy) of the distribution to be sampled,
including any constants.}

\item{neg_log_den_grad_func}{A function that computes the gradient of
\code{neg_log_den_func}.}

\item{leapfrog_stepsize}{A numeric value specifying the step size for the
leapfrog integration method.}

\item{leapfrog_step}{A numeric value specifying the number of leapfrog steps
to take to propose a new state.}

\item{current_pos}{A numeric vector representing the current position (state)
of the system.}
}
\value{
A list containing the following elements:
\itemize{
\item \code{position}: The position of the system after the leapfrog steps, which is
the proposed new position if accepted, or the current position
if rejected.
\item \code{potential_energy}: The potential energy of the proposed position.
\item \code{accepted}: A logical value indicating whether the proposal was accepted
(TRUE) or rejected (FALSE).
}
}
\description{
This function implements the Hamiltonian Monte Carlo algorithm as
described by Radford M. Neal (2010) in "MCMC using Hamiltonian dynamics",
which is a part of the Handbook of Markov Chain Monte Carlo. The method uses
Hamiltonian dynamics to propose new positions and then applies the Metropolis
criterion to decide whether to accept or reject the new position.
}
\details{
This function was written for illustrative purposes. More elaborate
on Radford M. Neal's personal webpage (http://www.cs.utoronto.ca/~radford/).
}
\references{
Neal, R. M. (2012). MCMC using Hamiltonian dynamics.
arXiv:1206.1901. Available at: \url{https://arxiv.org/pdf/1206.1901}
}
