% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prints.R
\name{print.cat_gibbs}
\alias{print.cat_gibbs}
\title{Print Summary of \code{cat_gibbs} Model}
\usage{
\method{print}{cat_gibbs}(x, digit = 3, detail = TRUE, ...)
}
\arguments{
\item{x}{A \code{cat_gibbs} model object containing the results of a Bayesian GLM fitted using Gibbs sampling.}

\item{digit}{An integer indicating the number of decimal places for printing
coefficient estimates. Default is 3.}

\item{detail}{A logical value indicating whether to include additional detailed output at the end of the summary.
If \code{TRUE}, it will print additional interpretation help.}

\item{...}{Additional parameters to pass to other functions.}
}
\value{
The \code{x} object is returned invisibly.
}
\description{
This function prints a summary of the \code{cat_gibbs} model, displaying details about the formula, covariate dimensions,
family, coefficients, and Gibbs sampling settings.
}
\details{
The summary includes:
\itemize{
\item The function name and formula used in the model.
\item Dimensions of the covariate matrix.
\item Family and link function details.
\item Sampling information, including the total iterations, warm-up iterations, and effective Gibbs sampling post-warmup.
\item Coefficients with summary statistics and effective sample size.
}

If \code{detail} is set to TRUE, additional guidance for interpreting the printed output is provided.
}
