% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_glm_tune.R
\name{steinian_estimate}
\alias{steinian_estimate}
\title{Perform Steinian Estimate for Model Risk (Only Applicable for Binomial Family)}
\usage{
steinian_estimate(formula, cat_init, tau_seq, tau_0, ...)
}
\arguments{
\item{formula}{A formula specifying the GLMs. Should at least include response variables.}

\item{cat_init}{A list generated from \code{cat_glm_initialization}.}

\item{tau_seq}{A sequence of tuning parameter values (\code{tau}) over which
the Steinian estimate will be computed. Each value of \code{tau} is used to weight the
synthetic data during model fitting.}

\item{tau_0}{A reference value for \code{tau} that is used in the calculation of the
preliminary estimate model and the variance term.}

\item{...}{Other arguments passed to other internal functions.}
}
\value{
A numeric vector of Steinian risk estimates, one for each value of \code{tau} in \code{tau_seq}.
}
\description{
This function computes the Steinian estimate for model risk by fitting a sequence of
Generalized Linear Models (GLMs) with varying values of \code{tau}. It combines the preliminary
estimate from a model fitted with an initial \code{tau_0} value with a penalty term that incorporates
the in-sample prediction error and a covariance penalty, which is based on models fitted by inverting
the response of individual observations.
}
\details{
\enumerate{
\item \strong{Preliminary Estimate Model}: The function first fits a GLM model using the observed and
synthetic data with an initial value of \code{tau_0} for the synthetic data weights.
\item \strong{In-sample Prediction Error}: For each value of \code{tau} in \code{tau_seq}, the function computes
the in-sample prediction error (logistic deviance).
\item \strong{Steinian Penalty}: The function calculates the Steinian covariance penalty for each observation
by fitting a modified model that inverts one observation at a time. The penalty is added to the
in-sample prediction error to obtain the final risk estimate.
\item \strong{Steinian Risk Estimate}: The final Steinian risk estimate is calculated by summing the
in-sample prediction error and the Steinian penalty term for each value of \code{tau} in \code{tau_seq}.
}
}
