% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causalCmprsk-functions.R
\name{summary.cmprsk}
\alias{summary.cmprsk}
\title{Summary of Event-specific Cumulative Hazards, Cumulative Incidence Functions and Various Treatment Effects}
\usage{
\method{summary}{cmprsk}(object, event, estimand = "CIF", ...)
}
\arguments{
\item{object}{an object of class \code{cmprsk} (output from \code{fit.nonpar} or \code{fit.cox} functions)}

\item{event}{an integer number (a code) of an event of interest}

\item{estimand}{a character string naming the type of estimand to extract from \code{object}. \code{estimand} can be one of the following: "CumHaz" (Cumulative Hazard function),
"CIF" (Cumulative Incidence Function), "RMT" (Restricted Mean Time),
"logHR" (logarithm of the ratio of Cumulative Hazards in two treatment arms),
"RD" (Risk Difference, or the difference between the CIFs in two treatment arms),
"RR" (Risk Ratio, or the ratio of CIFs in two treatment arms),
"ATE.RMT" (Restricted mean time gained/lost due to treatment, or the difference between RMTs in two treatment arms).
The default value is "CIF".}

\item{...}{This is not currently used, included for future methods.}
}
\value{
\code{summary.cmprsk} returns a \code{data.frame} object with 7 or 6 columns:
the time vector, an indicator of the treatment arm
(if the requested \code{estimand} is one of c("logHR", "RD", "RR", "ATE.RMT"), this column is omitted),
an indicator of the type of event,
the point estimate for the requested \code{estimand}, the lower and upper bounds of the
confidence interval (for \code{conf.level} \% of the confidence level),
and the standard error of the point estimate. For example, if \code{estimand="CIF"},
the returned \code{data.frame} will include the following columns:
\code{time}, \code{TRT}, \code{Event}, \code{CIF}, \code{CIL.CIF}, \code{CIU.CIF}, \code{SE.CIF}.
}
\description{
Returns an object of class \code{data.frame} containing the summary extracted from the \code{cmprsk} object.
}
\examples{
# create a data set
n <- 1000
set.seed(7)
c1 <-  runif(n)
c2 <- as.numeric(runif(n)< 0.2)
set.seed(77)
cf.m.T1 <- rweibull(n, shape=1, scale=exp(-(-1 + 2*c1)))
cf.m.T2 <-  rweibull(n, shape=1, scale=exp(-(1 + 1*c2)))
cf.m.T <- pmin( cf.m.T1, cf.m.T2)
cf.m.E <- rep(0, n)
cf.m.E[cf.m.T1<=cf.m.T2] <- 1
cf.m.E[cf.m.T2<cf.m.T1] <- 2
set.seed(77)
cf.s.T1 <- rweibull(n, shape=1, scale=exp(-1*c1 ))
cf.s.T2 <-  rweibull(n, shape=1, scale=exp(-2*c2))
cf.s.T <- pmin( cf.s.T1, cf.s.T2)
cf.s.E <- rep(0, n)
cf.s.E[cf.s.T1<=cf.s.T2] <- 1
cf.s.E[cf.s.T2<cf.s.T1] <- 2
exp.z <- exp(0.5 + c1 - c2)
pr <- exp.z/(1+exp.z)
TRT <- ifelse( runif(n)< pr, 1, 0)
X <- ifelse(TRT==1, cf.m.T, cf.s.T)
E <- ifelse(TRT==1, cf.m.E, cf.s.E)
covs.names <- c("c1", "c2")
data <- data.frame(X=X, E=E, TRT=TRT, c1=c1, c2=c2)
# Nonparametric estimation:
form.txt <- paste0("TRT", " ~ ", paste0(c("c1", "c2"), collapse = "+"))
trt.formula <- as.formula(form.txt)
res.ATE <- fit.nonpar(df=data, X="X", E="E", trt.formula=trt.formula, wtype="stab.ATE")
# summarizing results on the Risk Difference for event=2
fit.summary <- summary(object=res.ATE, event = 2, estimand="RD")
head(fit.summary)
# summarizing results on the CIFs for event=1
fit.summary <- summary(object=res.ATE, event = 1, estimand="CIF")
head(fit.summary)

}
\references{
M.-L. Charpignon, B. Vakulenko-Lagun, B. Zheng, C. Magdamo, B. Su, K.E. Evans, S. Rodriguez, et al. 2022. Causal inference in medical records and complementary systems pharmacology for metformin drug repurposing towards dementia. Nature Communications 13:7652.
}
\seealso{
\code{\link{fit.cox}}, \code{\link{fit.nonpar}}, \code{\link{causalCmprsk}}
}
