% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian_causens.R
\name{bayesian_causens}
\alias{bayesian_causens}
\title{Bayesian parametric sensitivity analysis for causal inference}
\usage{
bayesian_causens(
  trt_model,
  outcome_model,
  U_model,
  data,
  beta_uy = ~dunif(-2, 2),
  alpha_uz = ~dunif(-2, 2),
  backend = "jags",
  output_trace = FALSE,
  ...
)
}
\arguments{
\item{trt_model}{The treatment model object as a formula.}

\item{outcome_model}{The outcome model object as a formula.}

\item{U_model}{The unmeasured confounder model object as
a formula.}

\item{data}{A data frame containing the exposure, outcome, and confounder
variables.}

\item{beta_uy}{Prior distribution for the effect of the missing confounder U
on the outcome Y.}

\item{alpha_uz}{Prior distribution for the effect of the missing confounder U
on the treatment assignment mechanism Z.}

\item{backend}{The backend to use for the sensitivity analysis. Currently
only "jags" is supported.}

\item{output_trace}{Whether to output the full trace of the MCMC sampler.}

\item{...}{Additional arguments to be passed to the backend.}
}
\value{
A list of posterior samples for the causal effect of the exposure
variable on the outcome, as well as the confounder-adjusted causal effect.
}
\description{
This function runs a Bayesian sensitivity analysis for causal
inference using JAGS or Stan as a backend. For now, only JAGS is supported.
}
