% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reachable_states.R
\name{get_reachable_states}
\alias{get_reachable_states}
\title{Find Cycle in Permutation Group}
\usage{
get_reachable_states(start_state, allowed_positions, k, verbose = FALSE)
}
\arguments{
\item{start_state}{Integer vector, the initial permutation state}

\item{allowed_positions}{Character vector, sequence of operations to repeat}

\item{k}{Integer, parameter for reverse operations}

\item{verbose}{Logical; if TRUE, prints progress and cycle information messages (default FALSE)}
}
\value{
List containing:
\item{states}{List of all visited states}
\item{reachable_states_df}{Data frame with states, operations, and step numbers}
\item{operations}{Vector of operations applied}
\item{total_moves}{Total number of moves in the cycle}
\item{unique_states_count}{Number of unique states visited}
\item{cycle_info}{Summary string with cycle statistics}
}
\description{
Explores the Cayley graph starting from an initial state and applying
a sequence of operations repeatedly until returning to the start state.
Returns detailed information about all visited states and the cycle structure.
}
\examples{
# Simple example with letter codes
result <- get_reachable_states(1:20, c("L", "X"), k = 4)
writeLines(result$cycle_info)

# Example with numeric codes
n <- 20
k <- 4
start_state <- 1:n
allowed_positions <- c("1", "3", "2")
result <- get_reachable_states(start_state, allowed_positions, k)
writeLines(result$cycle_info)
head(result$reachable_states_df)
}
