% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-table.R
\name{download_table-deprecated}
\alias{download_table-deprecated}
\alias{download_table}
\title{Download a table from statistics Netherlands}
\usage{
download_table(
  id,
  ...,
  dir = id,
  cache = FALSE,
  verbose = TRUE,
  typed = FALSE,
  base_url = getOption("cbsodataR.base_url", BASE_URL)
)
}
\arguments{
\item{id}{Identifier of CBS table (can be retrieved from \code{\link[=cbs_get_toc]{cbs_get_toc()}})}

\item{...}{Parameters passed on to \code{\link[=cbs_download_data]{cbs_download_data()}}}

\item{dir}{Directory where table should be downloaded}

\item{cache}{If metadata is cached use that, otherwise download meta data}

\item{verbose}{Print extra messages what is happening.}

\item{typed}{Should the data automatically be converted into integer and numeric?}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol.}
}
\value{
meta data object of \code{id} \code{\link[=cbs_get_meta]{cbs_get_meta()}}.
}
\description{
This method is deprecated in favor of \code{\link[=cbs_download_table]{cbs_download_table()}}.
}
\details{
\code{cbs_download_table} retrieves all raw meta data and data and stores these as csv
files in the directory specified by \code{dir}. It is possible to add a filter.
A filter is specified with \verb{<column_name> = <values>} in which \verb{<values>}
is a character vector.
Rows with values that are not part of the character vector are not returned.
}
\examples{
\dontrun{

# download meta data and data from inflation/Consumer Price Indices
 download_table(id="7196ENG")
}
}
\seealso{
Other download: 
\code{\link{cbs_download_data}()},
\code{\link{cbs_download_meta}()}
}
