% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCDL_bbox.R
\name{getCDL_bbox}
\alias{getCDL_bbox}
\title{Get CDL raster data for a bounding box}
\usage{
getCDL_bbox(
  year,
  bbox,
  fileName,
  res,
  crs = "EPSG:5070",
  https = TRUE,
  alternativeUrl,
  ssl.verifypeer = TRUE,
  returnType = "raster"
)
}
\arguments{
\item{year}{A numerical vector. A set of years of CDL data to download.}

\item{bbox}{An array defining a bounding box of length four.  Defining the two points that form the box by latitude then longitude, in that order.  The furthest north west pair is entered first.}

\item{fileName}{An optional string indicating where the file should be saved to, default is an R tempfile.}

\item{res}{An optional array of length two defining the pixel resolution in meters, default is 30m.}

\item{crs}{An optional string containing the coordinate reference system, default is EPSG:5070 (Albers is EPSG:5070).}

\item{https}{Legacy https, all traffic uses https, if you need http provide alternative url.}

\item{alternativeUrl}{An optional string containing an alternative url.}

\item{ssl.verifypeer}{An optional boolean to turn on and off ssl verfication, default is on.}

\item{returnType}{An optional parameter to select to return either 'raster' or 'terra' based raster files.}
}
\value{
A raster object containing the contents of a bounding box.
}
\description{
\code{getCDL_bbox} retrieves a CDL raster object within a bounding box for a set of years.
}
\examples{
\dontrun{
# Get data for California in 2020
bbox <- c(130783,2203171,153923,2217961)
resx <- 30 
resy <- 30 
year <- 2020
crs <- 'epsg:102004'
getCDL_bbox(year,bbox,res=c(resx,resy),crs=crs)
}
}
\author{
Jonathan Lisic, \email{jlisic@gmail.com}

Jemma Stachelek, \email{stachel2@msu.edu}
}
