% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energetics.R
\name{partition_data}
\alias{partition_data}
\title{Organize Seahorse Data}
\usage{
partition_data(
  seahorse_rates,
  assay_types = list(basal = "MITO", uncoupled = "MITO", maxresp = "MITO", nonmito =
    "MITO", no_glucose_glyc = "GLYCO", glucose_glyc = "GLYCO", max_glyc = "GLYCO"),
  basal_tp = 3,
  uncoupled_tp = 6,
  maxresp_tp = 8,
  nonmito_tp = 12,
  no_glucose_glyc_tp = 3,
  glucose_glyc_tp = 6,
  max_glyc_tp = 8
)
}
\arguments{
\item{seahorse_rates}{A data.table of OCR and ECAR rates returned by \code{read_data}}

\item{assay_types}{A list that configures data partitioning based on the type of assay. See details.}

\item{basal_tp}{Basal respiration time point. Must be less than \code{uncoupled_tp}}

\item{uncoupled_tp}{ATP-coupled respiration time point. Must be less than \code{maxresp_tp}}

\item{maxresp_tp}{Maximal uncoupled respiration time point. Must be less than \code{nonmito_tp}}

\item{nonmito_tp}{Non-mitochondrial respiration time point. Must be larger than \code{maxresp_tp}}

\item{no_glucose_glyc_tp}{No glucose added acidification time point. Must be less than \code{glucose_glyc_tp}}

\item{glucose_glyc_tp}{Glucose-associated acidification time point. Must be less than \code{max_glyc_tp}}

\item{max_glyc_tp}{Maximal acidification time point. Must be less than \code{twodg_glyc_tp}}
}
\value{
a list of named time points from each assay cycle
}
\description{
Organizes Seahorse OCR and ECAR rates based on defined time points (i.e. the
Measurement column) during the experiment. This time point can be specified
if you are modifying the Mito and Glyco Stress Test (i.e. from 3 measurements
per cycle to X measurements)
}
\details{
\strong{Note:}
When we use the term 'max' in the package documentation we mean the maximal
experimental OCR and ECAR values rather than absolute biological maximums.

\code{partition_data} sets up the rates data for ATP calculations by the
\code{get_energetics} function. To do this, it takes a list \code{assay_types} with
the named values \code{basal}, \code{uncoupled}, \code{maxresp}, \code{nonmito},
\code{no_glucose_glyc}, \code{glucose_glyc}, and \code{max_glyc}. In the default setting,
it is configured for an experiment with both Mito and Glyco assays. However,
partitioning can be configured for other experimental conditions.
\itemize{
\item Only MITO data:
}

\preformatted{partitioned_data <- partition_data(
  seahorse_rates,
  assay_types = list(
    basal = "MITO",
    uncoupled = "MITO",
    maxresp = "MITO",
    nonmito = "MITO",
    no_glucose_glyc = NA,
    glucose_glyc = "MITO",
    max_glyc = NA
  ),
  basal_tp = 3,
  uncoupled_tp = 6,
  maxresp_tp = 8,
  nonmito_tp = 12,
  no_glucose_glyc_tp = NA,
  glucose_glyc_tp = 3,
  max_glyc_tp = NA
)
}

Respiratory control ratio (RCR) and glycolytic capacity (GC) assay:

\preformatted{partitioned_data <- partition_data(
  seahorse_rates,
  assay_types = list(
    basal = "RCR",
    uncoupled = "RCR",
    maxresp = "RCR,"
    nonmito = "RCR",
    no_glucose_glyc = NA,
    glucose_glyc = "GC",
    max_glyc = "GC"
  ),
  basal_tp = 3,
  uncoupled_tp = 6,
  maxresp_tp = 8,
  nonmito_tp = 12,
  no_glucose_glyc = NA,
  glucose_glyc_tp = 3,
  max_glyc_tp = 9
)
}
\itemize{
\item Data according to Mookerjee \emph{et al.} 2017 \emph{J Biol Chem};\emph{292}:7189-207.
}

\preformatted{partitioned_data <- partition_data(
  seahorse_rates,
  assay_types = list(
    basal = "RefAssay",
    uncoupled = "RefAssay",
    maxresp = NA,
    nonmito = "RefAssay",
    no_glucose_glyc = "RefAssay",
    glucose_glyc = "RefAssay",
    max_glyc = NA
  ),
  basal_tp = 5,
  uncoupled_tp = 10,
  nonmito_tp = 12,
  maxresp = NA,
  no_glucose_glyc_tp = 1,
  glucose_glyc_tp = 5,
  max_glyc = NA
)
}

Also see the vignette.
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
partitioned_data <- partition_data(seahorse_rates)
}
