% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeMarkers.R
\name{mergeMarkers}
\alias{mergeMarkers}
\title{Merge cellMarker signatures}
\usage{
mergeMarkers(
  mk1,
  mk2,
  remove_subclass = NULL,
  remove_group = NULL,
  transform = c("qq", "linear.qq", "scale", "none"),
  scale = 1,
  ...
)
}
\arguments{
\item{mk1}{The reference 'cellMarkers' class object.}

\item{mk2}{A 'cellMarkers' class object containing cell signatures to merge
into \code{mk1}.}

\item{remove_subclass}{Optional character vector of subclasses to remove when
merging.}

\item{remove_group}{Optional character vector of cell groups to remove when
merging.}

\item{transform}{Either "qq" which applies \code{\link[=quantile_map]{quantile_map()}} to \code{mk2} to
quantile transform it onto the same distribution as \code{mk1},
"linear.qq", which determines the quantile transformation and then
applies a linear approximation of this, "scale" which simply scales the
gene expression by the value \code{scale}, or "none" for no transformation.}

\item{scale}{Numeric value determining the scaling factor for \code{mk2} if
\code{transform} is set to "scale".}

\item{...}{Optional arguments and settings passed to \code{\link[=updateMarkers]{updateMarkers()}}.}
}
\value{
A list object of S3 class 'cellMarkers'. See \code{\link[=cellMarkers]{cellMarkers()}} for
details. If \code{transform = "qq"} then an additional element \code{qqmerge} is
returned containing the quantile mapping function between the 2 datasets.
}
\description{
Takes 2 cellMarkers signatures, merges them and recalculates optimal gene
signatures.
}
\seealso{
\code{\link[=cellMarkers]{cellMarkers()}} \code{\link[=updateMarkers]{updateMarkers()}} \code{\link[=quantile_map]{quantile_map()}}
}
