% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_acs.R, R/memoise.R
\name{build_acs}
\alias{build_acs}
\alias{mem_build_acs}
\title{Build Data from the American Community Survey}
\usage{
build_acs(
  geography,
  state = NULL,
  county = NULL,
  geometry = TRUE,
  year = 2020,
  survey = "acs5",
  groups = "all"
)

mem_build_acs(
  geography,
  state = NULL,
  county = NULL,
  geometry = TRUE,
  year = 2020,
  survey = "acs5",
  groups = "all"
)
}
\arguments{
\item{geography}{Required. The geography level to use.}

\item{state}{Required. Two letter state postal code.}

\item{county}{Optional. Name of county.  If not provided, returns blocks for the entire state.}

\item{geometry}{Defaults to TRUE. Whether to return the geometry or not.}

\item{year}{year, must be 2000, 2010, or 2020 (after August 2021)}

\item{survey}{whether the get estimates from the 5-year ('acs5'), 3-year ('acs3'),
or 1-year ('acs1') survey. Default is 'acs5'.}

\item{groups}{defaults to 'all', which gets pop and vap. If 'pop', only gets pop.
If 'vap', only gets vap. Any other strings default to 'all'.}
}
\value{
tibble with observations for each observation of the geography in the state
or county. Data includes up to 3 sets of columns for each race or ethnicity category:
population (pop), voting age population (vap), and citizen voting age population (cvap)
}
\description{
Creates a dataset, using the decennial census information, with the
standard variables used for redistricting. Creates a stable base for getting
data from \code{censusapi} for common calls in redistricting.

#' # Output columns are:
\itemize{
\item GEOID: Geographic Identifier
\item NAME: Name of County
\item pop: total population
\item pop_white: total population, Non-Hispanic White
\item pop_black: total population, Non-Hispanic Black
\item pop_hisp: total population, Hispanic
\item pop_aian: total population, Non-Hispanic American Indian and Alaskan Native
\item pop_asian: total population, Non-Hispanic Asian
\item pop_nhpi: total population, Non-Hispanic Native Hawaiian and Pacific Islander
\item pop_other: total population, Non-Hispanic Other
\item pop_two: total population, Non-Hispanic Two Plus Races
\item vap: voting age population
\item vap_white: voting age population, Non-Hispanic White
\item vap_black: voting age population, Non-Hispanic Black
\item vap_hisp: voting age population, Hispanic
\item vap_aian: voting age population, Non-Hispanic American Indian and Alaskan Native
\item vap_asian: voting age population, Non-Hispanic Asian
\item vap_nhpi: voting age population, Non-Hispanic Native Hawaiian and Pacific Islander
\item vap_other: voting age population, Non-Hispanic Other
\item vap_two: voting age population, Non-Hispanic Two Plus Races
\item geometry: sf geometry
}

Arguments for \code{geography} are not checked, so will error if invalid.
This is by design to avoid blocking usage that could become valid.

Currently valid options for \code{geography}:
\itemize{
\item 'state'
\item 'county'
\item 'tract'
\item 'block group'
\item 'block'
\item 'county subdivision'
\item 'zcta'
\item 'congressional district'
\item 'state legislative district (upper chamber)'
\item 'state legislative district (lower chamber)'
\item 'school district (unified)'
\item 'school district (elementary)'
\item 'school district (secondary)'
}
}
\examples{
\dontshow{if (has_census_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# uses the Census API
tb <- build_acs(geography = 'tract', state = 'NY', county = 'Rockland', geometry = TRUE)
\dontshow{\}) # examplesIf}
}
\concept{build}
