% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceser_main.R
\name{vcovCESE}
\alias{vcovCESE}
\title{Cluster Estimated Standard Errors}
\usage{
vcovCESE(mod, cluster = NULL, type = NULL)
}
\arguments{
\item{mod}{a model object. It can be the output of the functions \code{lm}, \code{glm}, or other regression function that returns compatible objects.}

\item{cluster}{either a string vector with the name of the variables that will be used to cluster the standard errors, or a formula - e.g., ~ rhs, with a summation of the variables that will be used to cluster the standard errors replacing the \code{rhs} -, or a vector, matrix, or data.frame with the clustering data.}

\item{type}{string with either \code{HC0}, \code{HC1}, \code{HC2}, \code{HC3}, or \code{HC4}. It specifies the type of heteroskedasticity correction to use  (see Davidson and MacKinnon (1993) and Hayes and Cai (2007)).}
}
\value{
The function returns a variance-covariace matrix of the coefficient estimates using the Cluster Estimated Standard Error (CESE) method.
}
\description{
Cluster Estimated Standard Errors (CESE)
}
\examples{

mod  = lm(enep ~  enpc + fapres + enpcfapres + proximity + eneg + logmag + logmag_eneg , data=dcese)

## --------------------------------------
## Getting the variance covariance matrix
## -------------------------------------- 
## Original variance-covariance matrix (no clustered std. errors)
vcov(mod)

## Variance-covariance matrix using CRSE (sandwish package)
## sandwich::vcovCL(mod, cluster = ~ country)
## sandwich::vcovCL(mod, cluster = ~ country, type="HC3")

## Variance-covariance matrix using CESE
ceser::vcovCESE(mod, cluster = ~ country)
ceser::vcovCESE(mod, cluster = ~ country, type="HC3") # HC3 correction

## ---------
## Summaries
## ---------
## no robust SE 
summary(mod)                                                                          

## summary table using CRSE (sandwich package)
## lmtest::coeftest(mod, vcov = sandwich::vcovCL, cluster = ~ country)                   

## summary using CESE
lmtest::coeftest(mod, vcov = ceser::vcovCESE, cluster = ~ country, type='HC3')


}
\references{
Jackson, John (2019) Corrected Standard Errors with Clustered Data. Political Analysis.

Hayes, A. F., & Cai, L., (2007) Using heteroskedasticity-consistent standard error estimators in ols regression: an introduction and software implementation, Behavior research methods, 39(4), 709–722.

Davidson, R., & MacKinnon, J. G., (2004) Econometric theory and methods: Oxford University Press New York.
}
