% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_calendar}
\alias{cfbd_calendar}
\title{\strong{Get calendar of weeks by season.}}
\usage{
cfbd_calendar(year)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}
}
\value{
\code{\link[=cfbd_calendar]{cfbd_calendar()}} - A data frame with 5 variables:
\describe{
\item{\code{season}: character.}{Calendar season.}
\item{\code{week}: integer.}{Calendar game week.}
\item{\code{season_type}: character}{Season type of calendar week.}
\item{\code{first_game_start}: character.}{First game start time of the calendar week.}
\item{\code{last_game_start}: character.}{Last game start time of the calendar week.}
}
}
\description{
\strong{Get calendar of weeks by season.}
}
\examples{
\donttest{
  try(cfbd_calendar(2019))
}
}
\seealso{
Other CFBD Games: 
\code{\link{cfbd_game_box_advanced}()},
\code{\link{cfbd_game_info}()},
\code{\link{cfbd_game_media}()},
\code{\link{cfbd_game_player_stats}()},
\code{\link{cfbd_game_records}()},
\code{\link{cfbd_game_team_stats}()},
\code{\link{cfbd_game_weather}()},
\code{\link{cfbd_live_scoreboard}()}
}
\concept{CFBD Games}
