% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_wepa_players_passing}
\alias{cfbd_metrics_wepa_players_passing}
\title{\strong{Get opponent-adjusted player passing statistics for predicted points added (PPA)}}
\usage{
cfbd_metrics_wepa_players_passing(
  year = NULL,
  team = NULL,
  conference = NULL,
  position = NULL
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}

\item{position}{(\emph{string} optional): Position abbreviation of the player you are searching for.
Position Group  - options include:
\itemize{
\item Offense: QB, RB, FB, TE,  OL, G, OT, C, WR
\item Defense: DB, CB, S, LB,  DE, DT, NT, DL
\item Special Teams: K, P, LS, PK
}}
}
\value{
\code{\link[=cfbd_metrics_wepa_players_passing]{cfbd_metrics_wepa_players_passing()}} - A data frame with 8 variables:\tabular{ll}{
   col_name \tab types \cr
   year \tab integer \cr
   athlete_id \tab character \cr
   athlete_name \tab character \cr
   position \tab character \cr
   team \tab character \cr
   conference \tab character \cr
   wepa \tab numeric \cr
   plays \tab integer \cr
}
}
\description{
\strong{Get opponent-adjusted player passing statistics for predicted points added (PPA)}
}
\examples{
\donttest{
  try(cfbd_metrics_wepa_players_passing(year = 2019, team = "TCU"))
}
}
\seealso{
Other CFBD Metrics: 
\code{\link{cfbd_metrics_fg_ep}()},
\code{\link{cfbd_metrics_ppa_games}()},
\code{\link{cfbd_metrics_ppa_players_games}()},
\code{\link{cfbd_metrics_ppa_players_season}()},
\code{\link{cfbd_metrics_ppa_predicted}()},
\code{\link{cfbd_metrics_ppa_teams}()},
\code{\link{cfbd_metrics_wepa_players_kicking}()},
\code{\link{cfbd_metrics_wepa_players_rushing}()},
\code{\link{cfbd_metrics_wepa_team_season}()},
\code{\link{cfbd_metrics_wp}()},
\code{\link{cfbd_metrics_wp_pregame}()}
}
\concept{CFBD Metrics}
\keyword{Adjusted}
\keyword{Opponent}
\keyword{Passing}
\keyword{Players}
\keyword{Points}
\keyword{Predicted}
