% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_pbp_data.R
\name{cfbd_pbp_data}
\alias{cfbd_pbp_data}
\title{\strong{Get college football play by play data with cfbfastR expected points/win probability added}}
\usage{
cfbd_pbp_data(
  year,
  season_type = "regular",
  week = 1,
  team = NULL,
  play_type = NULL,
  epa_wpa = FALSE,
  ...
)
}
\arguments{
\item{year}{Select year, (example: 2018)}

\item{season_type}{(\emph{String} default regular): Season type - regular, postseason, both, allstar, spring_regular, spring_postseason}

\item{week}{Select week, this is optional (also numeric)}

\item{team}{Select team name (example: Texas, Texas A&M, Clemson)}

\item{play_type}{Select play type (example: see the \link{cfbd_play_type_df})}

\item{epa_wpa}{Logical parameter (TRUE/FALSE) to return the Expected Points Added/Win Probability Added variables}

\item{...}{Additional arguments passed to an underlying function.}
}
\value{
A data frame with 368 variables:\tabular{ll}{
   col_name \tab types \cr
   season \tab numeric \cr
   wk \tab numeric \cr
   id_play \tab character \cr
   game_id \tab integer \cr
   game_play_number \tab numeric \cr
   half_play_number \tab numeric \cr
   drive_play_number \tab numeric \cr
   pos_team \tab character \cr
   def_pos_team \tab character \cr
   pos_team_score \tab integer \cr
   def_pos_team_score \tab integer \cr
   half \tab factor \cr
   period \tab integer \cr
   clock_minutes \tab integer \cr
   clock_seconds \tab integer \cr
   play_type \tab character \cr
   play_text \tab character \cr
   down \tab numeric \cr
   distance \tab numeric \cr
   yards_to_goal \tab numeric \cr
   yards_gained \tab numeric \cr
   EPA \tab numeric \cr
   ep_before \tab numeric \cr
   ep_after \tab numeric \cr
   wpa \tab numeric \cr
   wp_before \tab numeric \cr
   wp_after \tab numeric \cr
   def_wp_before \tab numeric \cr
   def_wp_after \tab numeric \cr
   penalty_detail \tab character \cr
   yds_penalty \tab numeric \cr
   penalty_1st_conv \tab logical \cr
   new_series \tab numeric \cr
   firstD_by_kickoff \tab numeric \cr
   firstD_by_poss \tab numeric \cr
   firstD_by_penalty \tab numeric \cr
   firstD_by_yards \tab numeric \cr
   def_EPA \tab numeric \cr
   home_EPA \tab numeric \cr
   away_EPA \tab numeric \cr
   home_EPA_rush \tab numeric \cr
   away_EPA_rush \tab numeric \cr
   home_EPA_pass \tab numeric \cr
   away_EPA_pass \tab numeric \cr
   total_home_EPA \tab numeric \cr
   total_away_EPA \tab numeric \cr
   total_home_EPA_rush \tab numeric \cr
   total_away_EPA_rush \tab numeric \cr
   total_home_EPA_pass \tab numeric \cr
   total_away_EPA_pass \tab numeric \cr
   net_home_EPA \tab numeric \cr
   net_away_EPA \tab numeric \cr
   net_home_EPA_rush \tab numeric \cr
   net_away_EPA_rush \tab numeric \cr
   net_home_EPA_pass \tab numeric \cr
   net_away_EPA_pass \tab numeric \cr
   success \tab numeric \cr
   epa_success \tab numeric \cr
   rz_play \tab numeric \cr
   scoring_opp \tab numeric \cr
   middle_8 \tab logical \cr
   stuffed_run \tab numeric \cr
   change_of_pos_team \tab numeric \cr
   downs_turnover \tab numeric \cr
   turnover \tab numeric \cr
   pos_score_diff_start \tab numeric \cr
   pos_score_pts \tab numeric \cr
   log_ydstogo \tab numeric \cr
   ExpScoreDiff \tab numeric \cr
   ExpScoreDiff_Time_Ratio \tab numeric \cr
   half_clock_minutes \tab numeric \cr
   TimeSecsRem \tab numeric \cr
   adj_TimeSecsRem \tab numeric \cr
   Goal_To_Go \tab logical \cr
   Under_two \tab logical \cr
   home \tab character \cr
   away \tab character \cr
   home_wp_before \tab numeric \cr
   away_wp_before \tab numeric \cr
   home_wp_after \tab numeric \cr
   away_wp_after \tab numeric \cr
   end_of_half \tab numeric \cr
   pos_team_receives_2H_kickoff \tab numeric \cr
   lead_pos_team \tab character \cr
   lead_play_type \tab character \cr
   lag_pos_team \tab character \cr
   lag_play_type \tab character \cr
   orig_play_type \tab character \cr
   Under_three \tab logical \cr
   down_end \tab factor \cr
   distance_end \tab numeric \cr
   log_ydstogo_end \tab numeric \cr
   yards_to_goal_end \tab numeric \cr
   TimeSecsRem_end \tab numeric \cr
   Goal_To_Go_end \tab logical \cr
   Under_two_end \tab logical \cr
   offense_score_play \tab numeric \cr
   defense_score_play \tab numeric \cr
   ppa \tab numeric \cr
   yard_line \tab integer \cr
   scoring \tab logical \cr
   pos_team_timeouts_rem_before \tab numeric \cr
   def_pos_team_timeouts_rem_before \tab numeric \cr
   pos_team_timeouts \tab integer \cr
   def_pos_team_timeouts \tab integer \cr
   pos_score_diff \tab integer \cr
   pos_score_diff_start_end \tab numeric \cr
   offense_play \tab character \cr
   defense_play \tab character \cr
   offense_receives_2H_kickoff \tab numeric \cr
   change_of_poss \tab numeric \cr
   score_pts \tab numeric \cr
   score_diff_start \tab numeric \cr
   score_diff \tab integer \cr
   offense_score \tab integer \cr
   defense_score \tab integer \cr
   offense_conference \tab character \cr
   defense_conference \tab character \cr
   off_timeout_called \tab numeric \cr
   def_timeout_called \tab numeric \cr
   offense_timeouts \tab integer \cr
   defense_timeouts \tab integer \cr
   off_timeouts_rem_before \tab numeric \cr
   def_timeouts_rem_before \tab numeric \cr
   rusher_player_name \tab character \cr
   yds_rushed \tab numeric \cr
   passer_player_name \tab character \cr
   receiver_player_name \tab character \cr
   yds_receiving \tab numeric \cr
   yds_sacked \tab numeric \cr
   sack_players \tab character \cr
   sack_player_name \tab character \cr
   sack_player_name2 \tab character \cr
   pass_breakup_player_name \tab character \cr
   interception_player_name \tab character \cr
   yds_int_return \tab numeric \cr
   fumble_player_name \tab character \cr
   fumble_forced_player_name \tab character \cr
   fumble_recovered_player_name \tab character \cr
   yds_fumble_return \tab numeric \cr
   punter_player_name \tab character \cr
   yds_punted \tab numeric \cr
   punt_returner_player_name \tab character \cr
   yds_punt_return \tab numeric \cr
   yds_punt_gained \tab numeric \cr
   punt_block_player_name \tab character \cr
   punt_block_return_player_name \tab character \cr
   fg_kicker_player_name \tab character \cr
   yds_fg \tab numeric \cr
   fg_block_player_name \tab character \cr
   fg_return_player_name \tab character \cr
   kickoff_player_name \tab character \cr
   yds_kickoff \tab numeric \cr
   kickoff_returner_player_name \tab character \cr
   yds_kickoff_return \tab numeric \cr
   new_id \tab numeric \cr
   orig_drive_number \tab integer \cr
   drive_number \tab integer \cr
   drive_result_detailed \tab character \cr
   new_drive_pts \tab numeric \cr
   drive_id \tab numeric \cr
   drive_result \tab character \cr
   drive_start_yards_to_goal \tab numeric \cr
   drive_end_yards_to_goal \tab integer \cr
   drive_yards \tab integer \cr
   drive_scoring \tab numeric \cr
   drive_pts \tab numeric \cr
   drive_start_period \tab integer \cr
   drive_end_period \tab integer \cr
   drive_time_minutes_start \tab integer \cr
   drive_time_seconds_start \tab integer \cr
   drive_time_minutes_end \tab integer \cr
   drive_time_seconds_end \tab integer \cr
   drive_time_minutes_elapsed \tab logical \cr
   drive_time_seconds_elapsed \tab logical \cr
   drive_numbers \tab numeric \cr
   number_of_drives \tab numeric \cr
   pts_scored \tab numeric \cr
   drive_result_detailed_flag \tab character \cr
   drive_result2 \tab character \cr
   drive_num \tab numeric \cr
   lag_drive_result_detailed \tab character \cr
   lead_drive_result_detailed \tab character \cr
   lag_new_drive_pts \tab numeric \cr
   id_drive \tab character \cr
   rush \tab numeric \cr
   rush_td \tab numeric \cr
   pass \tab numeric \cr
   pass_td \tab numeric \cr
   completion \tab numeric \cr
   pass_attempt \tab numeric \cr
   target \tab numeric \cr
   sack_vec \tab numeric \cr
   sack \tab numeric \cr
   int \tab numeric \cr
   int_td \tab numeric \cr
   turnover_vec \tab numeric \cr
   turnover_vec_lag \tab numeric \cr
   turnover_indicator \tab numeric \cr
   kickoff_play \tab numeric \cr
   receives_2H_kickoff \tab numeric \cr
   missing_yard_flag \tab logical \cr
   scoring_play \tab numeric \cr
   td_play \tab numeric \cr
   touchdown \tab numeric \cr
   safety \tab numeric \cr
   fumble_vec \tab numeric \cr
   kickoff_tb \tab numeric \cr
   kickoff_onside \tab numeric \cr
   kickoff_oob \tab numeric \cr
   kickoff_fair_catch \tab numeric \cr
   kickoff_downed \tab numeric \cr
   kickoff_safety \tab numeric \cr
   kick_play \tab numeric \cr
   punt \tab numeric \cr
   punt_play \tab numeric \cr
   punt_tb \tab numeric \cr
   punt_oob \tab numeric \cr
   punt_fair_catch \tab numeric \cr
   punt_downed \tab numeric \cr
   punt_safety \tab numeric \cr
   punt_blocked \tab numeric \cr
   penalty_safety \tab numeric \cr
   fg_inds \tab numeric \cr
   fg_made \tab logical \cr
   fg_make_prob \tab numeric \cr
   No_Score_before \tab numeric \cr
   FG_before \tab numeric \cr
   Opp_FG_before \tab numeric \cr
   Opp_Safety_before \tab numeric \cr
   Opp_TD_before \tab numeric \cr
   Safety_before \tab numeric \cr
   TD_before \tab numeric \cr
   No_Score_after \tab numeric \cr
   FG_after \tab numeric \cr
   Opp_FG_after \tab numeric \cr
   Opp_Safety_after \tab numeric \cr
   Opp_TD_after \tab numeric \cr
   Safety_after \tab numeric \cr
   TD_after \tab numeric \cr
   penalty_flag \tab logical \cr
   penalty_declined \tab logical \cr
   penalty_no_play \tab logical \cr
   penalty_offset \tab logical \cr
   penalty_text \tab logical \cr
   penalty_play_text \tab character \cr
   lead_wp_before2 \tab numeric \cr
   wpa_half_end \tab numeric \cr
   wpa_base \tab numeric \cr
   wpa_base_nxt \tab numeric \cr
   wpa_change \tab numeric \cr
   wpa_change_nxt \tab numeric \cr
   wpa_base_ind \tab numeric \cr
   wpa_base_nxt_ind \tab numeric \cr
   wpa_change_ind \tab numeric \cr
   wpa_change_nxt_ind \tab numeric \cr
   lead_wp_before \tab numeric \cr
   lead_pos_team2 \tab character \cr
   row \tab integer \cr
   drive_event_number \tab numeric \cr
   lag_play_type2 \tab character \cr
   lag_play_type3 \tab character \cr
   lag_play_text \tab character \cr
   lag_play_text2 \tab character \cr
   lead_play_text \tab character \cr
   lag_first_by_penalty \tab numeric \cr
   lag_first_by_penalty2 \tab numeric \cr
   lag_first_by_yards \tab numeric \cr
   lag_first_by_yards2 \tab numeric \cr
   first_by_penalty \tab numeric \cr
   first_by_yards \tab numeric \cr
   play_after_turnover \tab numeric \cr
   lag_change_of_poss \tab numeric \cr
   lag_change_of_pos_team \tab numeric \cr
   lag_change_of_pos_team2 \tab numeric \cr
   lag_kickoff_play \tab numeric \cr
   lag_punt \tab numeric \cr
   lag_punt2 \tab numeric \cr
   lag_scoring_play \tab numeric \cr
   lag_turnover_vec \tab numeric \cr
   lag_downs_turnover \tab numeric \cr
   lag_defense_score_play \tab numeric \cr
   lag_score_diff \tab numeric \cr
   lag_offense_play \tab character \cr
   lead_offense_play \tab character \cr
   lead_offense_play2 \tab character \cr
   lag_pos_score_diff \tab numeric \cr
   lag_off_timeouts \tab numeric \cr
   lag_def_timeouts \tab numeric \cr
   lag_TimeSecsRem2 \tab numeric \cr
   lag_TimeSecsRem \tab numeric \cr
   lead_TimeSecsRem \tab numeric \cr
   lead_TimeSecsRem2 \tab numeric \cr
   lag_yards_to_goal2 \tab integer \cr
   lag_yards_to_goal \tab integer \cr
   lead_yards_to_goal \tab numeric \cr
   lead_yards_to_goal2 \tab integer \cr
   lag_down2 \tab integer \cr
   lag_down \tab integer \cr
   lead_down \tab numeric \cr
   lead_down2 \tab numeric \cr
   lead_distance \tab numeric \cr
   lead_distance2 \tab integer \cr
   lead_play_type2 \tab character \cr
   lead_play_type3 \tab character \cr
   lag_ep_before3 \tab numeric \cr
   lag_ep_before2 \tab numeric \cr
   lag_ep_before \tab numeric \cr
   lead_ep_before \tab numeric \cr
   lead_ep_before2 \tab numeric \cr
   lag_ep_after \tab numeric \cr
   lag_ep_after2 \tab numeric \cr
   lag_ep_after3 \tab numeric \cr
   lead_ep_after \tab numeric \cr
   lead_ep_after2 \tab numeric \cr
   play_number \tab integer \cr
   wallclock \tab character \cr
   provider \tab character \cr
   spread \tab numeric \cr
   formatted_spread \tab character \cr
   over_under \tab numeric \cr
   drive_is_home_offense \tab logical \cr
   drive_start_offense_score \tab integer \cr
   drive_start_defense_score \tab integer \cr
   drive_end_offense_score \tab integer \cr
   drive_end_defense_score \tab integer \cr
   play \tab numeric \cr
   event \tab numeric \cr
   game_event_number \tab numeric \cr
   game_row_number \tab integer \cr
   half_play \tab numeric \cr
   half_event \tab numeric \cr
   half_event_number \tab numeric \cr
   half_row_number \tab integer \cr
   lag_distance3 \tab integer \cr
   lag_distance2 \tab integer \cr
   lag_distance \tab integer \cr
   lag_yards_gained3 \tab integer \cr
   lag_yards_gained2 \tab integer \cr
   lag_yards_gained \tab integer \cr
   lead_yards_gained \tab integer \cr
   lead_yards_gained2 \tab integer \cr
   lag_play_text3 \tab character \cr
   lead_play_text2 \tab character \cr
   lead_play_text3 \tab character \cr
   pos_unit \tab character \cr
   def_pos_unit \tab character \cr
   lag_change_of_poss2 \tab numeric \cr
   lag_change_of_poss3 \tab numeric \cr
   lag_change_of_pos_team3 \tab numeric \cr
   lag_kickoff_play2 \tab numeric \cr
   lag_kickoff_play3 \tab numeric \cr
   lag_punt3 \tab numeric \cr
   lag_scoring_play2 \tab numeric \cr
   lag_scoring_play3 \tab numeric \cr
   lag_turnover_vec2 \tab numeric \cr
   lag_turnover_vec3 \tab numeric \cr
   lag_downs_turnover2 \tab numeric \cr
   lag_downs_turnover3 \tab numeric \cr
   drive_play \tab numeric \cr
   drive_event \tab numeric \cr
   lag_first_by_penalty3 \tab numeric \cr
   lag_first_by_yards3 \tab numeric \cr
}
}
\description{
Extract college football (D-I) play by play Data - for plays
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ # Get play by play data for 2025 regular season week 1
 cfbd_pbp_data(year = 2025, week = 1, season_type = 'regular', epa_wpa = TRUE)
}\if{html}{\out{</div>}}
}
\seealso{
Other CFBD PBP: 
\code{\link{cfbd_live_plays}()},
\code{\link{cfbd_play_stats_player}()},
\code{\link{cfbd_play_stats_types}()},
\code{\link{cfbd_play_types}()},
\code{\link{cfbd_plays}()}
}
\concept{CFBD PBP}
\keyword{Play-by-Play}
