% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_ratings_sp}
\alias{cfbd_ratings_sp}
\title{\strong{Get SP historical rating data}}
\usage{
cfbd_ratings_sp(year = NULL, team = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY}). Required if team not provided}

\item{team}{(\emph{String} optional): D-I Team. Required if year not provided}
}
\value{
\code{\link[=cfbd_ratings_sp]{cfbd_ratings_sp()}} - A data frame with 26 variables:\tabular{ll}{
   col_name \tab types \cr
   year \tab integer \cr
   team \tab character \cr
   conference \tab character \cr
   rating \tab numeric \cr
   ranking \tab integer \cr
   second_order_wins \tab numeric \cr
   sos \tab numeric \cr
   offense_ranking \tab integer \cr
   offense_rating \tab numeric \cr
   offense_success \tab numeric \cr
   offense_explosiveness \tab numeric \cr
   offense_rushing \tab numeric \cr
   offense_passing \tab numeric \cr
   offense_standard_downs \tab numeric \cr
   offense_passing_downs \tab numeric \cr
   offense_run_rate \tab numeric \cr
   offense_pace \tab numeric \cr
   defense_ranking \tab integer \cr
   defense_rating \tab numeric \cr
   defense_success \tab numeric \cr
   defense_explosiveness \tab numeric \cr
   defense_rushing \tab numeric \cr
   defense_passing \tab numeric \cr
   defense_standard_downs \tab numeric \cr
   defense_passing_downs \tab numeric \cr
   defense_havoc_total \tab numeric \cr
   defense_havoc_front_seven \tab numeric \cr
   defense_havoc_db \tab numeric \cr
   special_teams_rating \tab numeric \cr
}
}
\description{
At least one of \strong{year} or \strong{team} must be specified for the function to run
}
\examples{
\donttest{
  try(cfbd_ratings_sp(year = 2018))

  try(cfbd_ratings_sp(team = "Texas A&M"))

  try(cfbd_ratings_sp(year = 2019, team = "Texas"))
}

}
\seealso{
Other CFBD Ratings and Rankings: 
\code{\link{cfbd_rankings}()},
\code{\link{cfbd_ratings_elo}()},
\code{\link{cfbd_ratings_fpi}()},
\code{\link{cfbd_ratings_sp_conference}()},
\code{\link{cfbd_ratings_srs}()}
}
\concept{CFBD Ratings and Rankings}
\keyword{SP+}
