% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfmortality.R
\name{predictcfmortality}
\alias{predictcfmortality}
\title{Predicts 1- and 2- year Mortality Prediction Models in Cystic Fibrosis (CF)}
\source{
\url{https://erj.ersjournals.com/content/early/2019/05/08/13993003.00224-2019}
}
\usage{
predictcfmortality(
  age,
  male,
  fvc,
  fev1,
  fev1LastYear,
  bcepacia,
  underweight,
  nHosp,
  pancreaticInsufficient,
  CFRelatedDiabetes,
  ageAtDiagnosis
)
}
\arguments{
\item{age}{Patient age, in years}

\item{male}{A binary variable with 0 for females and 1 for males}

\item{fvc}{FVC percent predicted in the current year (0-150)}

\item{fev1}{FEV1 percent predicted in the current year (0-150)}

\item{fev1LastYear}{FEV1 percent predicted in the preceding year (0-150)}

\item{bcepacia}{A binary with 0 for no B. cepacia complex and 1 for B. cepacia complex}

\item{underweight}{A binary with 1 for underweight (BMI < 18.5 if age >= 19 or BMI percentile <= 12\% if age < 19)}

\item{nHosp}{An integer number of hospitalizations in preceding year}

\item{pancreaticInsufficient}{A binary taking 1 for pancreatic insufficient status and 0 otherwise}

\item{CFRelatedDiabetes}{A binary variable for CF related diabetes}

\item{ageAtDiagnosis}{A number for age at CF diagnosis in years}
}
\value{
1- and 2-year predicted mortality risk
}
\description{
Predicts 1- and 2- year Mortality Prediction Models in Cystic Fibrosis (CF)
}
\examples{
predictcfmortality (age = 16, male = 0, fvc = 66.7, fev1 = 47.4, fev1LastYear = 80.5, 
                    bcepacia = 0, underweight = 0, nHosp = 0, pancreaticInsufficient = 1, 
                    CFRelatedDiabetes = 0, ageAtDiagnosis = 0.9)
predictcfmortality (age = 40.4, male = 1, fvc = 25.7, fev1 = 19.2, fev1LastYear = 20, 
                    bcepacia = 1, underweight = 1, nHosp = 6, pancreaticInsufficient = 0, 
                    CFRelatedDiabetes = 0, ageAtDiagnosis = 27.2)
predictcfmortality (age = 44, male = 1, fvc = 72.95, fev1 = 55.5, fev1LastYear = 52.5, 
                    bcepacia = 0, underweight = 1, nHosp = 0, pancreaticInsufficient = 0, 
                    CFRelatedDiabetes = 0, ageAtDiagnosis = 29)

}
