% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_with_missing.R
\name{calibrate.online.network.missing}
\alias{calibrate.online.network.missing}
\title{Calibrate step for online change point detection for network data with missing values.}
\usage{
calibrate.online.network.missing(
  train_miss_list,
  train_eta_list,
  threshold_len,
  alpha_grid,
  permu_num,
  pi_lb_hat,
  pi_ub_hat,
  rho_hat,
  rank_hat,
  C_lambda = 2/3,
  delta = 5
)
}
\arguments{
\item{train_miss_list}{A \code{list} of adjacency matrices (with entries being 0 or 1) with missing values being coercing to 0.}

\item{train_eta_list}{A \code{list} of matrices associated with data_incomplete_list, each matrix indicates the missing entries in corresponding adjacency matrix.}

\item{threshold_len}{An \code{integer} scalar of the length of tuned thresholds.}

\item{alpha_grid}{A \code{numeric} vector in (0,1) representing the desired false alarm rate.}

\item{permu_num}{An \code{integer} scalar of number of random permutation for calibration.}

\item{pi_lb_hat}{A \code{numeric} scalar of the lower bound of the missing probability.}

\item{pi_ub_hat}{A \code{numeric} scalar of the upper bound of the missing probability.}

\item{rho_hat}{A \code{numeric} scalar of the sparsity parameter.}

\item{rank_hat}{An \code{integer} scalar of the rank of the underlying graphon matrix.}

\item{C_lambda}{A \code{numeric} scalar of an absolute constant, which is set to be 2/3 by default.}

\item{delta}{An \code{integer} scalar of minimum spacing.}
}
\value{
A \code{list} with the following structure:
 \item{C_lambda}{The absolute constant}
 \item{rho_hat}{the (estimated) sparsity parameter}
 \item{rank_hat}{the (estimated) rank of underlying graphon matrix}
 \item{pi_lb_hat}{the (estimated) lower bound of the missing probability}
 \item{pi_ub_hat}{the (estimated) upper bound of the missing probability}
 \item{thresholds_array}{A \code{numeric} array of calibrated threshold}
}
\description{
Calibrate step for online change point detection for network data by controlling the false alarm rate at level alpha.
}
\examples{
p = 6 # number of nodes
rho = 0.5 # sparsity parameter
block_num = 3 # number of groups for SBM
train_obs_num = 150 # sample size for each segment
conn1_mat = rho * matrix(c(0.6,1,0.6,1,0.6,0.5,0.6,0.5,0.6), nrow = 3) # connectivity matrix 
set.seed(1)
can_vec = sample(1:p, replace = FALSE) # randomly assign nodes into groups
sbm = simu.SBM(conn1_mat, can_vec, train_obs_num, symm = TRUE, self = TRUE)
train_mat = sbm$obs_mat
train_list = lapply(1:ncol(train_mat), function(t) lowertri2mat(train_mat[,t], p, diag = TRUE))
pi_mat = matrix(0.9, p, p)
train_eta_list = lapply(1:length(train_list), function(t) gen.missing(pi_mat, symm = TRUE))
train_miss_list = lapply(1:length(train_list), function(t) train_eta_list[[t]] * train_list[[t]])
pi_lb_hat = quantile(Reduce("+", train_eta_list)/train_obs_num, 0.05) # estimator of pi_lb
pi_ub_hat = quantile(Reduce("+", train_eta_list)/train_obs_num, 0.95) # estimator of pi_ub
C_lambda = 2/3
lambda = lambda.network.missing(1, length(train_miss_list), length(train_miss_list), 0.05, 
                                rho = 0.509, pi_ub = pi_ub_hat, p, C_lambda)
graphon_miss_impute = softImpute.network.missing(train_miss_list, train_eta_list, lambda, 1)
graphon_miss_hat = graphon_miss_impute$u \%*\% diag(as.numeric(graphon_miss_impute$d)) \%*\% 
                   t(graphon_miss_impute$v)
rho_hat = quantile(graphon_miss_hat, 0.95)
rank_hat = sum(graphon_miss_impute$d != 0)
alpha_grid = c(0.05)
permu_num = 10
threshold_len = 30
temp = calibrate.online.network.missing(train_miss_list, train_eta_list, threshold_len, alpha_grid, 
                   permu_num, pi_lb_hat, pi_ub_hat, rho_hat, rank_hat, C_lambda, delta = 5)
}
\references{
Dubey, Xu and Yu (2021) <arxiv:2110.06450>
}
\seealso{
\code{\link{online.network.missing}} for detecting online change point.
}
\author{
Haotian Xu
}
