% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_loglik_methods.R
\name{alrtest}
\alias{alrtest}
\title{Adjusted Likelihood Ratio Test of Nested Models}
\usage{
alrtest(object, ...)
}
\arguments{
\item{object}{a \code{chantrics} object as returned from \code{\link[=adj_loglik]{adj_loglik()}}.}

\item{...}{further object specifications (see details), as well as named
parameters that will be passed to \code{\link[chandwich:compare_models]{chandwich::compare_models()}}. The type
of adjustment, out of \code{"vertical"}, \code{"cholesky"}, \code{"spectral"}, \code{"none"},
as specified in the parameter \code{type}, can also be specified here.}
}
\value{
An object of class \code{"anova"} inheriting from class \code{"data.frame"}.
The columns are as follows: \item{Resid.df}{The residual number of degrees
of freedom in the model.} \item{df}{The increase in residual degrees of
freedom with respect to the model in the row above.} \item{ALRTS}{The
adjusted likelihood ratio statistic.} \item{Pr(>ALRTS)}{The p-value of the
test that the model above is a "significantly better" model as the one in
the current row.}
}
\description{
\code{alrtest} is a helper function to simulate the functions \code{\link[lmtest:waldtest]{lmtest::waldtest()}}
and \code{\link[lmtest:lrtest]{lmtest::lrtest()}} for adjusted \code{chantrics} objects. The method can be
employed to compare nested models (see details).
}
\details{
This function is a helper function that creates an interface to
\code{\link[=anova.chantrics]{anova.chantrics()}} that is similar to \code{\link[lmtest:waldtest]{lmtest::waldtest()}} and
\code{\link[lmtest:lrtest]{lmtest::lrtest()}}.

The standard method is to compare the fitted model object \code{object} with the
models in \code{...}. Instead of passing the fitted models into \code{...}, other
specifications are possible. Note that the types of specifications cannot be
mixed, except between numerics/characters. The type of the second object
supplied determines the algorithm used.
\itemize{
\item \strong{\code{"chantrics"} objects}: When
supplying two or more \code{"chantrics"} objects, they will be sorted as in
\code{\link[=anova.chantrics]{anova.chantrics()}}. Then, the ALRTS will be computed consecutively between
the two neighbouring models. Note that all models must be nested. For
details refer to \code{\link[=anova.chantrics]{anova.chantrics()}}.
\item \strong{\code{"numeric"}}: If the second
object is \code{"numeric"} or \code{"character"}, then \code{"numeric"} objects
corresponding element in \code{attr(terms(object1), "term.labels")} will be
turned into their corresponding \code{"character"} element and will be handled
as in \code{"character"} below.
\item \strong{\code{"character"}}: If the second object is
\code{"numeric"} or \code{"character"}, then the \code{"character"} objects are
consecutively included in an update formula like \code{update(object1, . ~ . -   object2)}
\item \strong{\code{"formula"}}: If the second object is a \code{"formula"}, then
the second model will be computed as \code{update(object1, object2)}.
}

Then, the adjusted likelihood ratio test statistic (ALRTS), as described in
Section 3.5 of Chandler and Bate
(2007), is computed by
\code{\link[=anova.chantrics]{anova.chantrics()}}.

If a single unnamed object is passed in \code{...}, sequential ANOVA is
performed on \code{object}.
}
\references{
R. E. Chandler and S. Bate, Inference for clustered data using the
independence loglikelihood, Biometrika, 94 (2007), pp.
167–183. \doi{10.1093/biomet/asm015}.
}
\seealso{
\code{\link[=anova.chantrics]{anova.chantrics()}} for the implementation of the computations of
the test statistics.

\code{\link[lmtest:waldtest]{lmtest::waldtest()}} and \code{\link[lmtest:lrtest]{lmtest::lrtest()}} for syntax.
}
