% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorem-provider.R
\name{LoremProvider}
\alias{LoremProvider}
\title{LoremProvider}
\description{
lorem ipsum methods for generating random words in a language.
Lorem Ipsum is a placeholder text commonly used to demonstrate the visual
form of a document or a typeface without relying on meaningful content.
}
\note{
You cannot instantiate the Parent providers. You must use one of
the localized one.
}
\seealso{
Other ParentProviders: 
\code{\link{AddressProvider}},
\code{\link{ColorProvider}},
\code{\link{CompanyProvider}},
\code{\link{InternetProvider}},
\code{\link{JobProvider}},
\code{\link{PersonProvider}},
\code{\link{PhoneNumberProvider}},
\code{\link{TaxonomyProvider}},
\code{\link{UserAgentProvider}}
}
\concept{ParentProviders}
\section{Super classes}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{LoremProvider}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LoremProvider-new}{\code{LoremProvider$new()}}
\item \href{#method-LoremProvider-word}{\code{LoremProvider$word()}}
\item \href{#method-LoremProvider-words}{\code{LoremProvider$words()}}
\item \href{#method-LoremProvider-sentence}{\code{LoremProvider$sentence()}}
\item \href{#method-LoremProvider-sentences}{\code{LoremProvider$sentences()}}
\item \href{#method-LoremProvider-paragraph}{\code{LoremProvider$paragraph()}}
\item \href{#method-LoremProvider-paragraphs}{\code{LoremProvider$paragraphs()}}
\item \href{#method-LoremProvider-text}{\code{LoremProvider$text()}}
\item \href{#method-LoremProvider-clone}{\code{LoremProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="allowed_locales"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-allowed_locales'><code>charlatan::BaseProvider$allowed_locales()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="print"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-print'><code>charlatan::BaseProvider$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LoremProvider} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$new(sentence_punctuation = ".", word_connector = " ")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sentence_punctuation}}{(character) End of sentence punctuation}

\item{\code{word_connector}}{(character) Default connector between words}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{LoremProvider} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-word"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-word}{}}}
\subsection{Method \code{word()}}{
Generate a random word
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$word(ext_words = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ext_words}}{a character vector of words you would like to have instead of "Lorem ipsum"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a single word
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-words"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-words}{}}}
\subsection{Method \code{words()}}{
Generate a character vector of random words
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$words(nb = 3, ext_words = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb}}{(integer) how many words to return}

\item{\code{ext_words}}{a character vector of words you would like to have instead of "Lorem ipsum"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
many words
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-sentence"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-sentence}{}}}
\subsection{Method \code{sentence()}}{
Generate a random sentence
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$sentence(
  nb_words = 6,
  variable_nb_words = TRUE,
  ext_words = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb_words}}{(integer) around how many words the sentence should
contain}

\item{\code{variable_nb_words}}{set to \code{FALSE} if you want exactly \code{nb}
words returned, otherwise the result may include a number of words
of \code{nb} +/-40\% (with a minimum of 1)}

\item{\code{ext_words}}{a character vector of words you would like to have instead of "Lorem ipsum"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a single sentence
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-sentences"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-sentences}{}}}
\subsection{Method \code{sentences()}}{
Generate a character vector of random sentences
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$sentences(nb = 3, ext_words = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb}}{(integer) how many sentences to return}

\item{\code{ext_words}}{a character vector of words you would like to have instead of "Lorem ipsum"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
many sentences
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-paragraph"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-paragraph}{}}}
\subsection{Method \code{paragraph()}}{
Generate a single paragraph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$paragraph(
  nb_sentences = 3,
  variable_nb_sentences = TRUE,
  ext_words = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb_sentences}}{(integer) around how many sentences the paragraph
should contain}

\item{\code{variable_nb_sentences}}{set to \code{FALSE} if you want exactly \code{nb}
sentences returned, otherwise the result may include a number of
sentences of \code{nb} +/-40\% (with a minimum of 1)}

\item{\code{ext_words}}{a character vector of words you would like to have instead of "Lorem ipsum"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a single paragraph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-paragraphs"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-paragraphs}{}}}
\subsection{Method \code{paragraphs()}}{
Generate many paragraphs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$paragraphs(nb = 3, ext_words = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nb}}{(integer) how many paragraphs to return}

\item{\code{ext_words}}{a character vector of words you would like to have instead of "Lorem ipsum"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
many paragraphs
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-text"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-text}{}}}
\subsection{Method \code{text()}}{
Generate a random text string. Depending on the
\code{max_nb_chars}, returns a string made of words, sentences, or
paragraphs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$text(max_nb_chars = 200, ext_words = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_nb_chars}}{Maximum number of characters the text should
contain (minimum 5)}

\item{\code{ext_words}}{a character vector of words you would like to have instead of "Lorem ipsum"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character string of words
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoremProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LoremProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoremProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
