% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_design.R
\name{check_design}
\alias{check_design}
\title{\code{R6} Checks Coordinator}
\description{
A stateful object that orchestrates all separate processes required to
manage installation, library setup and run \verb{R CMD check}s in sequence.
}
\examples{
\dontrun{
library(checked)
df <- source_check_tasks_df(c(
  system.file("example_packages", "exampleBad", package = "checked"),
  system.file("example_packages", "exampleGood", package = "checked")
))

plan <- check_design$new(df, n = 10, repos = "https://cran.r-project.org/")
while (!plan$is_done()) {
  plan$start_next_task()
}
}

}
\seealso{
Other checks: 
\code{\link{check_dev_rev_deps}()},
\code{\link{check_dir}()},
\code{\link{check_pkgs}()},
\code{\link{check_rev_deps}()},
\code{\link{new_check_design}()}
}
\concept{checks}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{graph}}{(\code{igraph::igraph()})\cr
A dependency graph, storing information about which dependencies
are required prior to execution of each check task.
Created with \code{\link[=task_graph_create]{task_graph_create()}}}

\item{\code{input}}{(\code{data.frame()})\cr
Checks task \code{data.frame} which is the source of all the checks.}

\item{\code{output}}{(\code{character(1)})\cr
Output directory where raw results and temporary library will
be created and stored.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-check_design-new}{\code{check_design$new()}}
\item \href{#method-check_design-active_processes}{\code{check_design$active_processes()}}
\item \href{#method-check_design-failed_tasks}{\code{check_design$failed_tasks()}}
\item \href{#method-check_design-terminate}{\code{check_design$terminate()}}
\item \href{#method-check_design-step}{\code{check_design$step()}}
\item \href{#method-check_design-start_next_task}{\code{check_design$start_next_task()}}
\item \href{#method-check_design-is_done}{\code{check_design$is_done()}}
\item \href{#method-check_design-clone}{\code{check_design$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-new"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new check design

Use checks data.frame to generate task graph in which all dependencies
and installation order are embedded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$new(
  df,
  n = 2L,
  output = tempfile(paste(packageName(), Sys.Date(), sep = "-")),
  lib.loc = .libPaths(),
  repos = getOption("repos"),
  restore = options::opt("restore"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{\code{check_design} data.frame.}

\item{\code{n}}{\code{integer} value indicating maximum number of subprocesses that
can be simultaneously spawned when executing tasks.}

\item{\code{output}}{\code{character} value specifying path where the output should
be stored.}

\item{\code{lib.loc}}{\code{character} vector with libraries allowed to be used when
checking packages, defaults to entire .libPaths().}

\item{\code{repos}}{\code{character} vector of repositories which will be used when
generating task graph and later pulling dependencies.}

\item{\code{restore}}{\code{logical} value, whether output directory should be
unlinked before running checks. If \code{FALSE}, an attempt will me made to
restore previous progress from the same \code{output}.}

\item{\code{...}}{Additional arguments unused}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{check_design}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-active_processes"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-active_processes}{}}}
\subsection{Method \code{active_processes()}}{
Get Active Processes list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$active_processes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-failed_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-failed_tasks}{}}}
\subsection{Method \code{failed_tasks()}}{
Get Failed Tasks list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$failed_tasks()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-terminate}{}}}
\subsection{Method \code{terminate()}}{
Kill All Active Design Processes

Immediately terminates all the active processes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$terminate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-step"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-step}{}}}
\subsection{Method \code{step()}}{
Fill Available Processes with Tasks
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$step()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A logical value, indicating whether processes are actively
running.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-start_next_task"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-start_next_task}{}}}
\subsection{Method \code{start_next_task()}}{
Start Next Task
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$start_next_task()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A integer value, coercible to logical to indicate whether a new
process was spawned, or \code{-1} if all tasks have finished.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-is_done"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-is_done}{}}}
\subsection{Method \code{is_done()}}{
Check if checks are done

Checks whether all the scheduled tasks were successfully executed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$is_done()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_design-clone"></a>}}
\if{latex}{\out{\hypertarget{method-check_design-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{check_design$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
