% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as_sarif_json}
\alias{as_sarif_json}
\title{Cast to SARIF json}
\usage{
as_sarif_json(x, path, pattern, which, ...)
}
\arguments{
\item{x}{an S3-object to convert.}

\item{path}{file path to write the SARIF json content to.}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{which}{a character vector, either \code{"global"} to include all unrecognized global variables,
\code{"import"} to include all detected imported functions and variables, or both (default).}

\item{...}{additional arguments to configure the returned output.}
}
\value{
json object.
}
\description{
\code{as_sarif_json} is a generic function to cast objects returned by \code{\link{checkglobals}},
\code{\link{check_pkg}} or \code{\link{check_source}} to SARIF (Static Analysis Results Interchange Format) json
for upload to external CI tools (e.g. GitHub Code Scanning, Jenkins warnings-ng plugin or Azure DevOps).
The function invokes particular \emph{methods} which depend on the \code{\link{class}} of the first argument.
}
