% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{is_discrete}
\alias{is_discrete}
\title{Check if a vector is discrete}
\usage{
is_discrete(x, na.rm = TRUE)
}
\arguments{
\item{x}{A vector to check the discreteness of.}

\item{na.rm}{Whether or not to remove NA values before testing discreteness.
Defaults to TRUE.}
}
\value{
Logical, whether or not \code{x} is a discrete variable.
}
\description{
Whether or not a vector is a discrete variable, returns a logical.
Typically used on the Y variable of a model.
}
\examples{
library(cheem)

is_discrete(mtcars$mpg) ## Numeric column, with more than 25 unique values.
is_discrete(mtcars$cyl) ## Numeric column, labeled as discrete, because less than 25 unique values
is_discrete(letters)    ## Characters and factors labeled discrete.
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{color_scale_of}()},
\code{\link{contains_nonnumeric}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{problem_type}()},
\code{\link{sug_basis}()},
\code{\link{sug_manip_var}()}
}
\concept{cheem utility}
