% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_indicators.R
\name{AICC}
\alias{AICC}
\title{Akaike Information Criterion With Correction}
\usage{
AICC(fit)
}
\arguments{
\item{fit}{a 'nls'-object}
}
\value{
Returns the AICc value
}
\description{
The function calculates the Akaike Information Criterion with correction
for small samples size.
}
\details{
When the sample size is small, there is a substantial probability that AIC
(see \code{\link[stats:AIC]{stats::AIC()}} for more details)
will select models that have too many parameters, i.e. that AIC will
overfit. AICc is AIC with a correction for small sample sizes.

The AICc is computed as follows:
\deqn{AICc=AIC+\frac{2\,k\,(k+1)}{n-k-1}}
where n denotes the sample size and k denotes the number of parameters. Thus
, AICc is essentially AIC with an extra penalty term for the number of
parameters. Note that as \eqn{n\rightarrow \infty}, the extra penalty term
converges to 0, and thus AICc converges to AIC.
}
\examples{
t <- seq(0, 10, 1)
y <- 1 / (0.5 * exp(t) + 1) + stats::rnorm(length(t), 0, 0.05)

fit <- nls(y ~ 1 / (k * exp(t) + 1),
  data = list(t = t, y = y),
  start = list(k = 0.2)
)
AICC(fit)

}
\seealso{
\code{\link[stats:AIC]{stats::AIC()}} for uncorrected AIC, \code{\link[stats:AIC]{stats::BIC()}},
\code{\link[stats:sigma]{stats::sigma()}} ,\code{\link[=chiquad_red]{chiquad_red()}} for other goodness of fit indicators.
\code{\link[=goodness_of_fit]{goodness_of_fit()}}
}
