% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/game.R
\name{game}
\alias{game}
\title{Create a new game}
\usage{
game(headers = NULL, fen = NULL)
}
\arguments{
\item{headers}{A named list like \code{list("Header1" = "Value1", ...)}}

\item{fen}{FEN representing the starting position of the board}
}
\value{
A game root node
}
\description{
A game is a tree with nodes, where each node represents the
board after a move and each branch represents a variation of the game (not
to be confused with a variant of chess). This tree mirrors the
\href{https://en.wikipedia.org/wiki/Portable_Game_Notation}{PGN} of the game.

To explore a game, an object of this class supports \code{\link[=print]{print()}}, \code{\link[=plot]{plot()}},
\code{\link[=str]{str()}}, \code{\link[=fen]{fen()}}, \code{\link[=pgn]{pgn()}} and more.
}
