% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges_weights_vector.R
\name{edges_weights_vector}
\alias{edges_weights_vector}
\title{Create an edges weights vector}
\usage{
edges_weights_vector(x, y)
}
\arguments{
\item{x}{a \code{list} of length 2. The nodes_by_edges matrix returned by
\code{nodes_by_edges_matrix()} (or \code{aem.build.binary()} of the package
\code{adespatial}).}

\item{y}{a \code{data.frame} with the following three columns: \code{from}
(the first node of the edge), \code{to} (the second node of the edge), and
\code{weight} (the weight of the edge between the two nodes, e.g. a distance).}
}
\value{
An edges weights \code{vector}.
}
\description{
Creates an edges weights vector that can be used in \code{aem()} of the package
\code{adespatial}. Resulting edges weights equal to 0 will be replaced by
\verb{4 x max(w)}, where \code{max(w)} is the maximal weight in the matrix.
}
\examples{
# Import Adour sites ----
path_to_file <- system.file("extdata", "adour_survey_sampling.csv", 
                            package = "chessboard")
adour_sites <- read.csv(path_to_file)

# Select the 15 first sites ----
adour_sites <- adour_sites[1:15, ]

# Create node labels ----
adour_sites <- create_node_labels(adour_sites, 
                                  location = "location", 
                                  transect = "transect", 
                                  quadrat  = "quadrat")

# Convert sites to sf object (POINTS) ----
adour_sites_sf <- sf::st_as_sf(adour_sites, 
                               coords = c("longitude", "latitude"),
                               crs = "epsg:2154")

# Create edges based on the pawn move (directed network) ----
adour_edges <- create_edge_list(adour_sites, method = "pawn", 
                                directed = TRUE)

# Create nodes-by-edges matrix ----
adour_matrix <- nodes_by_edges_matrix(adour_edges)

# Compute Euclidean distances between pairs of sites ----
adour_dists <- distance_euclidean(adour_sites_sf)

# Create Edges weights vector ----
edges_weights_vector(adour_matrix, adour_dists)
}
