% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_chessboard.R
\name{gg_chessboard}
\alias{gg_chessboard}
\title{Plot a sampling as a chessboard}
\usage{
gg_chessboard(nodes, xlab = "Transect", ylab = "Quadrat")
}
\arguments{
\item{nodes}{a \code{data.frame} with (at least) the following three columns:
\code{node}, \code{transect}, and \code{quadrats}. Must be the output if the function
\code{\link[=create_node_labels]{create_node_labels()}}.}

\item{xlab}{a \code{character} of length 1. The title of the top axis.
Default is \code{'Transect'}.}

\item{ylab}{a \code{character} of length 1. The title of the left axis.
Default is \code{'Quadrat'}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plots a sampling as a chessboard of dimensions \code{t} x \code{q}, with
\code{t}, the number of transects, and
\code{q}, the number of quadrats.
}
\examples{
library("chessboard")

# Two-dimensional sampling ----
sites_infos <- expand.grid("transect" = 1:3, "quadrat" = 1:5)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")

gg_chessboard(nodes)

# One-dimensional sampling (only transects) ----
sites_infos <- data.frame("transect" = 1:5)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect")

gg_chessboard(nodes)

# One-dimensional sampling (only quadrats) ----
sites_infos <- data.frame("quadrat" = 1:5)

nodes <- create_node_labels(data    = sites_infos, 
                            quadrat = "quadrat")

gg_chessboard(nodes)
}
