% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_data.R
\name{choice_data}
\alias{choice_data}
\alias{generate_choice_data}
\alias{long_to_wide}
\alias{wide_to_long}
\title{Define choice data}
\usage{
choice_data(
  data_frame,
  format = "wide",
  column_choice = "choice",
  column_decider = "deciderID",
  column_occasion = NULL,
  column_alternative = NULL,
  column_ac_covariates = NULL,
  column_as_covariates = NULL,
  delimiter = "_",
  cross_section = is.null(column_occasion),
  choice_type = c("discrete", "ordered", "ranked")
)

generate_choice_data(
  choice_effects,
  choice_identifiers = generate_choice_identifiers(N = 100),
  choice_covariates = NULL,
  choice_parameters = NULL,
  choice_preferences = NULL,
  column_choice = "choice",
  choice_type = c("auto", "discrete", "ordered", "ranked")
)

long_to_wide(
  data_frame,
  column_ac_covariates = NULL,
  column_as_covariates = NULL,
  column_choice = "choice",
  column_alternative = "alternative",
  column_decider = "deciderID",
  column_occasion = NULL,
  alternatives = unique(data_frame[[column_alternative]]),
  delimiter = "_",
  choice_type = c("discrete", "ordered", "ranked")
)

wide_to_long(
  data_frame,
  column_choice = "choice",
  column_alternative = "alternative",
  alternatives = NULL,
  delimiter = "_",
  choice_type = c("discrete", "ordered", "ranked")
)
}
\arguments{
\item{data_frame}{[\code{data.frame}]\cr
Contains the choice data.}

\item{format}{[\code{character(1)}]\cr
Format of \code{data_frame}. Use \code{"wide"} when each row contains all alternatives
of an occasion and \code{"long"} when each row contains a single alternative.}

\item{column_choice}{[\code{character(1)}]\cr
Column name with the observed choices. In wide layout this column should
contain a single value per observation: for discrete data the value is the
label of the chosen alternative, for ordered data it is the ordered factor or
integer score, and for ranked data it is omitted in favour of one column per
alternative (see \code{choice_type}). In long layout the same column is evaluated
once per alternative: discrete data must use a binary indicator (1 for the
chosen alternative, 0 otherwise), ordered data repeats the ordinal value for
every alternative, and ranked data stores the integer rank \code{1:J} for each
alternative within an observation. Set to \code{NULL} when no observed choices are
available (e.g., for purely covariate tables).}

\item{column_decider}{[\code{character(1)}]\cr
Column name with decider identifiers.}

\item{column_occasion}{[\code{character(1)} | \code{NULL}]\cr
Column name with occasion identifiers. Set to \code{NULL} in cross-sectional data.}

\item{column_alternative}{[\code{character(1)} | \code{NULL}]\cr
Column name with alternative identifiers when \code{format = "long"}.}

\item{column_ac_covariates}{[\code{character()} | \code{NULL}]\cr
Column names with alternative-constant covariates.}

\item{column_as_covariates}{[\code{character()}]\cr
Column names of \code{data_frame} with alternative-specific covariates.}

\item{delimiter}{[\code{character(1)}]\cr
Delimiter separating alternative identifiers from covariate names in wide
format. May consist of one or more characters.}

\item{cross_section}{[\code{logical(1)}]\cr
Treat choice data as cross-sectional?}

\item{choice_type}{[\code{character(1)}]\cr
Requested response type. Use \code{"auto"} (default) to infer the mode from
\code{choice_alternatives()}, or explicitly simulate \code{"discrete"}, \code{"ordered"},
or \code{"ranked"} outcomes.}

\item{choice_effects}{[\code{choice_effects}]\cr
A \code{\link{choice_effects}} object describing the model.}

\item{choice_identifiers}{[\code{choice_identifiers}]\cr
A \code{\link{choice_identifiers}} object that provides the decider and
occasion identifiers.}

\item{choice_covariates}{[\code{choice_covariates}]\cr
Covariates to include in the generated data.}

\item{choice_parameters}{[\code{choice_parameters}]\cr
Model parameters supplying utilities and covariance structures.}

\item{choice_preferences}{[\code{choice_preferences}]\cr
Decider-specific preference draws used for simulation.}

\item{alternatives}{[\code{character(J)}]\cr
Unique labels for the choice alternatives.}
}
\value{
A \code{tibble} that inherits from \code{choice_data}.
}
\description{
The \code{choice_data} object defines the choice data, it is a combination of
\code{choice_responses} and \code{choice_covariates}.
}
\details{
\code{choice_data()} acts as the main entry point for observed data. It accepts
either long or wide layouts and performs validation before
returning a tidy tibble with consistent identifiers. Columns that refer to
the same alternative are aligned using \code{delimiter} so that downstream helpers
can detect them automatically. When used with ranked or ordered choices the
function checks that rankings are complete and warns about inconsistencies.

Internally the helper converts long inputs to wide format. This guarantees
that subsequent steps (such as computing probabilities) receive the same
structure regardless of the original layout and keeps the workflow concise.
\itemize{
\item \code{generate_choice_data()} simulates choice data.
\item \code{wide_to_long()} and \code{long_to_wide()} transform to wide and long format.
}

The generated \code{choice_data} object inherits a \code{choice_type} attribute for
the requested simulation mode. Ordered alternatives (\code{ordered = TRUE})
yield ordered responses, unordered alternatives default to discrete
multinomial outcomes, and ranked simulations return complete rankings for
every observation.
}
\examples{
### simulate data from a multinomial probit model
choice_effects <- choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ A | B, error_term = "probit",
    random_effects = c("A" = "cn")
  ),
  choice_alternatives = choice_alternatives(J = 3)
)
generate_choice_data(choice_effects)

### transform between long/wide format
long_to_wide(
  data_frame = travel_mode_choice,
  column_alternative = "mode",
  column_decider = "individual"
)
wide_to_long(
  data_frame = train_choice
)
}
\seealso{
\code{\link[=choice_responses]{choice_responses()}}, \code{\link[=choice_covariates]{choice_covariates()}}, and \code{\link[=choice_identifiers]{choice_identifiers()}} for
the helper objects that feed into \code{choice_data()}.
}
\keyword{data}
