% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_agilent_d.R
\name{read_agilent_d}
\alias{read_agilent_d}
\title{Read files from 'Agilent ChemStation' .D directories}
\usage{
read_agilent_d(
  path,
  what = c("chroms", "dad", "peak_table"),
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  collapse = TRUE
)
}
\arguments{
\item{path}{Path to 'Agilent' \code{.D} directory.}

\item{what}{Whether to extract chromatograms (\code{chroms}), DAD data
(\code{dad}) and/or peak tables \code{peak_table}. Accepts multiple arguments.
\code{ms_spectra}. Accepts multiple arguments.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{read_metadata}{Logical. Whether to attach metadata.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{collapse}{Logical. Whether to collapse lists that only contain a single
element.}
}
\value{
A list of chromatograms in the format specified by
\code{data_format} and #' \code{format_out}. If \code{data_format} is
\code{wide}, the chromatograms will be returned with retention times as rows
and columns containing signal intensity for each signal. If \code{long}
format is requested, retention times will be in the first column. The
\code{format_out} argument determines whether the chromatogram
is returned as a \code{matrix}, \code{data.frame} or \code{data.table}.
Metadata can be attached to the chromatogram as \code{\link{attributes}} if
\code{read_metadata} is \code{TRUE}.
}
\description{
Reads files from 'Agilent' \code{.D} directories.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
read_agilent_d("tests/testthat/testdata/RUTIN2.D")
\dontshow{\}) # examplesIf}
}
\seealso{
Other 'Agilent' parsers: 
\code{\link{read_agilent_dx}()},
\code{\link{read_chemstation_ch}()},
\code{\link{read_chemstation_csv}()},
\code{\link{read_chemstation_ms}()},
\code{\link{read_chemstation_reports}()},
\code{\link{read_chemstation_uv}()}
}
\author{
Ethan Bass
}
\concept{'Agilent' parsers}
