% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_aston.R
\name{sp_converter}
\alias{sp_converter}
\title{Converter for 'Agilent MassHunter' UV files}
\usage{
sp_converter(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw")
)
}
\arguments{
\item{path}{Path to file}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{read_metadata}{Logical. Whether to read metadata and attach it to the
chromatogram.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}
}
\value{
A chromatogram in \code{data.frame} format (retention time x wavelength).
}
\description{
Converts a single chromatogram from MassHunter \code{.sp} format to R
\code{data.frame} using the \href{https://github.com/bovee/aston}{Aston} file parser.
}
\seealso{
Other external parsers: 
\code{\link{call_entab}()},
\code{\link{call_openchrom}()},
\code{\link{call_rainbow}()},
\code{\link{read_thermoraw}()},
\code{\link{uv_converter}()}
}
\concept{external parsers}
