% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_data_fr.R
\name{as.data.frame.chronicle}
\alias{as.data.frame.chronicle}
\title{Coerce a chronicle object to a data.frame}
\usage{
\method{as.data.frame}{chronicle}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{A \code{chronicle} object.}

\item{row.names}{\code{NULL} or a character vector giving the row names for the
data frame.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting column
names is optional.}

\item{...}{Additional arguments to be passed to or from other methods.}
}
\value{
A \code{data.frame} if the \code{value} inside the chronicle object is a
\code{data.frame} or can be successfully coerced into one.
}
\description{
This is an S3 method that allows for the easy coercion of a \code{chronicle} object
into a standard \code{data.frame}. It automatically unwraps the object by calling
\code{unveil(.c, "value")} and then attempts to convert the result into a data frame.
}
\details{
The function will produce an error if the underlying \code{value} of the chronicle
object cannot be coerced to a data frame by the base \code{as.data.frame()} method.
The error message will be specific, indicating the class of the object that
caused the failure.
}
\examples{
library(dplyr)

# --- Successful Example ---

# Create a chronicle object whose value is a data frame
starwars_chronicle <- starwars \%>\%
  record(filter)(species == "Human") \%>\%
  bind_record(record(select), name, height, mass)

# Now, you can use as.data.frame() directly on the chronicle object
sw_df <- as.data.frame(starwars_chronicle)

class(sw_df)
head(sw_df)


# --- Error Example ---

# Create a chronicle object whose value is a number
numeric_chronicle <- record(sqrt)(100)

# This will fail with a specific error message because a number
# cannot be turned into a data frame.
try(as.data.frame(numeric_chronicle))

}
