% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_mean.R
\name{CalculateFeatureMean}
\alias{CalculateFeatureMean}
\title{Calculate arithmetic mean for a DAG feature}
\usage{
CalculateFeatureMean(x, p_feature, ...)
}
\arguments{
\item{x}{A chain(s) or collection object.}

\item{p_feature}{A function that takes an adjacency matrix or collection object
and returns a scalar corresponding to \eqn{f(g)}. The function must be of the
form p_feature(dag).}

\item{...}{Extra parameters sent to the methods. For a dag collection you can
choose to use estimated p(g|D) in two ways which can be specified using the
'method' parameter.method='sampled' for MCMC sampled frequency (which is our
recommended method) or method='score' which uses the normalised scores.}
}
\value{
A numeric value representing the posterior probability of the
feature.
}
\description{
Calculate the posterior expected value for a feature (\eqn{f(g)}, e.g.,
existence of an edge in graph \eqn{g}) by marginalising out the graph
structure \eqn{q} over the graph space \eqn{G}, thus
\deqn{E(f|D) = \sum_{g \in G} f(g) p(g|D).} This can be
useful for calculating point estimates of quantities of interests, such as
the probability that an edge exists or the probability of one node being
an ancestor of another.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)
dag_chains <- PartitiontoDAG(results, scorer)

# Calculate the mean edge probability per chain.
CalculateFeatureMean(dag_chains, function(x) { return(x) })

# Calculate the mean edge probability across chains.
CalculateFeatureMean(FlattenChains(dag_chains), function(x) { return(x) })

}
