% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec.predict.R
\name{ec.predict}
\alias{ec.predict}
\title{produces predictions for the VECM via its VAR companion form}
\usage{
ec.predict(est, det1, det2, ymat, npl, befpn, ndet, cal, kval = 1.959964)
}
\arguments{
\item{est}{output from estimation by ec.EG1.R}

\item{det1}{deterministic matrix of constant(s) and trend(s)}

\item{det2}{deterministic matrix of seasonals and point dummies}

\item{ymat}{matrix of lags}

\item{npl}{n, p, nlag}

\item{befpn}{begtrim, endtrim, nforecast, npred, nhstar}

\item{ndet}{order of the model d(i,j)}

\item{cal}{calendar, should match the number of rows in ymat}

\item{kval}{how many se to use, default kval= 1.959964}
}
\value{
list with contains:
afl (actual and 1 step ahead fitted levels)
afd (actual and 1 step ahead fitted differences)
fit (1 step ahead fit)
dynpred (dynamic predictions)
mAt mB (companion matrix and selection of it)
Sigmah (Sigmah for dyn forecasts)
forstartdate (starting date for dyn forecast)
outcal  (dates for the prediction)
h1star (h1star)
cspred (table with change in sign of pred for Dx_1)
indexfa (indices of forecast accuracy)
}
\description{
Predicts both in-sample (1 step ahead) and out-of-sample (1 step ahead and dynamic forecasts)
}
\references{
Berta et al. 2020
}
\author{
P. Berta, P. Paruolo, S. Verzillo, PG. Lovaglio
}
