% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_mwall.R
\name{move_from_mwall}
\alias{move_from_mwall}
\title{Move data locations from medial wall}
\usage{
move_from_mwall(xifti, value = NA, name = "Medial_Wall", RGBA = c(1, 1, 1, 0))
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{value}{The value to assign the medial wall locations. Default: \code{NA}.}

\item{name, RGBA}{Only used if the \code{"xifti"} has the dlabel intent and
\code{value} is not an already-existing Key. This is the name to assign to
the new key for the medial wall locations, as well as a length-four numeric
vector indicating the red, green, blue, and alpha values for the color to
assign to the new key. These will be reflected in the updated label table.
Note that RGBA values must all be in [0, 1].

Currently, only one name and set of RGBA values are supported, meaning that
the medial wall locations will have the same Key, name, and color across
all data columns in the \code{"xifti"}. An error will occur if the Key
already exists for some columns but not others.

Defaults: \code{"Medial_Wall"} for \code{"name"} and white with 0 alpha for
\code{RGBA}.}
}
\value{
The \code{"xifti"} with re-organized data and medial wall masks
}
\description{
Move all medial wall locations into the cortical data matrices by assigning
them a specific value (e.g. NA).
}
\seealso{
move_to_mwall

unmask_cortex
}
