% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bifid_delastelle.R
\name{bifid_delastelle}
\alias{bifid_delastelle}
\title{bifid_delastelle}
\usage{
bifid_delastelle(input, key = "", period = 100, encrypt = TRUE)
}
\arguments{
\item{input}{Word or phrase to be encrypted,
or character vector with the sequence of coordinate numbers if we need to decrypt}

\item{key}{key Word for creating the modified Polybius square}

\item{period}{period length for splitting the input phrase. If greater or equal to the length of the input then the split is not executed}

\item{encrypt}{If `TRUE` (default), the program ciphers the input word, If `FALSE`, the program decrypts it.}
}
\value{
a string
}
\description{
The bifid cipher is an encryption method that combines a substitution with a Polybius square and a transposition, and uses fractionation to achieve diffusion. 
It was invented by Felix Delastelle.
}
\examples{
bifid_delastelle("dcode", key = "secret", period = 3, encrypt = TRUE)
bifid_delastelle("apiai", key = "secret", period = 3, encrypt = FALSE)

}
\references{
https://en.wikipedia.org/wiki/Bifid_cipher
}
