% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invCIR.r
\name{doseFind}
\alias{doseFind}
\title{Inverse (dose-finding) point estimate (e.g., estimating a percentile)}
\usage{
doseFind(
  y,
  x = NULL,
  wt = NULL,
  estfun = cirPAVA,
  target = NULL,
  full = FALSE,
  dec = FALSE,
  extrapolate = FALSE,
  errOnFlat = FALSE,
  adaptiveShrink = FALSE,
  starget = target[1],
  tiemeth = "ordered",
  ...
)
}
\arguments{
\item{y}{can be either of the following: y values (response rates), a 2-column matrix with positive/negative response counts by dose, a \code{\link{DRtrace}} object or a \code{\link{doseResponse}} object.}

\item{x}{dose levels (if not included in y).}

\item{wt}{weights (if not included in y).}

\item{estfun}{the name of the dose-response estimation function. Default \code{\link{cirPAVA}}.}

\item{target}{A vector of target response rate(s), for which the percentile dose estimate is needed. See Note.}

\item{full}{logical, is a more complete output desired (relevant only for doseFind)? if \code{FALSE} (default), only a point estimate of the dose (x) for the provided target rate is returned.}

\item{dec}{(relevant only for doseFind) logical, is the true function is assumed to be monotone decreasing? Default \code{FALSE}.}

\item{extrapolate}{logical: should extrapolation beyond the range of estimated y values be allowed? Default \code{FALSE}.}

\item{errOnFlat}{logical: in case the forward estimate is completely flat making dose-finding infeasible, should an error be returned? Under default (\code{FALSE}), \code{NA}s are returned for the target estimate.}

\item{adaptiveShrink}{logical, should the y-values be pre-shrunk towards an experiment's target? Recommended if data were obtained via an adaptive dose-finding design. See \code{\link{DRshrink}} and the Note.}

\item{starget}{The shrinkage target. Defaults to \code{target[1]}.}

\item{tiemeth}{The method to resolve ties. Default \code{"decide"}, meaning the function chooses based on context. See Details.}

\item{...}{Other arguments passed on to \code{\link{doseResponse}} and \code{estfun}.}
}
\value{
under default, returns point estimate(s) of the dose (x) for the provided target rate(s). With \code{full=TRUE}, returns a list with
\itemize{
\item \code{targest}: The said point estimate of x
\item \code{input}:    a \code{doseResponse} object summarizing the input data
\item \code{output}:  a \code{doseResponse} object with the forward estimate at design points
\item \code{shrinkage}:  a \code{doseResponse} object which is the \code{alg} output of the forward-estimation function
}
}
\description{
Inverse ("dose-finding") point estimation of a dose (x) for a specified target y value (e.g., a response rate),
using a user-specified forward-estimation algorithm (default is CIR).
}
\details{
The function works by calling \code{estfun} for forward estimation of the x-y relationship, then using \code{\link{approx}} with the x and y roles reversed for inverse estimation. It is expected that most users will not interact with this function directly, but rather indirectly via the convenience wrapper \code{\link{quickInverse}}.

The \code{extrapolate} option sets the \code{rule} argument for this second call:
\itemize{
\item \code{extrapolate=TRUE} translates to \code{rule=2}, which actually means that the x value on the edge of the estimated y range will be assigned.
\item \code{extrapolate=FALSE} (default) translates to \code{rule=1}, which means an \code{NA} will be returned for any target y value lying outside the estimated y range.
}

Note also that the function is set up to work with a vector of targets.

If the data were obtained from an adaptive dose-finding design and you seek to estimate a dose other than the experiment's target, note that away from the target the estimates are likely biased (Flournoy and Oron, 2019). Use \code{adaptiveShrink=TRUE} to mitigate the bias. In addition, either provide the true target as \code{starget}, or a vector of values to \code{target}, with the first value being the true target.

Tie-breaking - the \code{tiemeth} argument passed on as the \code{ties} argument for \code{approx()} - provides yet another complication: as of 2.5.0, the default is \code{"decide"}, which means \code{"ordered"} - unless \code{target} falls on the boundary of \code{y} estimates, in which case the most interior \code{x} value is chosen. A user-chosen value for \code{tiemeth} will override all of that; see \code{?approx} for options.
}
\references{
Flournoy N and Oron AP, 2020. Bias Induced by Adaptive Dose-Finding Designs. Journal of Applied Statistics 47, 2431-2442.
}
\seealso{
\code{\link{oldPAVA}},\code{\link{cirPAVA}}. If you'd like point and interval estimates together, use \code{\link{quickInverse}}.
}
\author{
Assaf P. Oron \code{<assaf.oron.at.gmail.com>}
}
