% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccGenomicAxis}
\alias{ccGenomicAxis}
\title{Add genomic axes}
\usage{
ccGenomicAxis(
  h = "top",
  major.at = NULL,
  labels = NULL,
  major.by = NULL,
  tickLabelsStartFromZero = TRUE,
  labels.cex = 0.4 * par("cex"),
  ...
)
}
\arguments{
\item{h}{Position of the axes. "top" or "bottom".
}

\item{major.at}{Major breaks. If \code{major.at} is set, \code{major.by} is ignored.
}

\item{labels}{labels corresponding to \code{major.at}. If \code{labels} is set, \code{major.at} must be set.
}

\item{major.by}{Increment of major ticks. It is calculated automatically if the value is not set (about every 10 degrees there is a major tick).
}

\item{tickLabelsStartFromZero}{Whether axis tick labels start from 0? This will only affect the axis labels while not affect x-values in cells.
}

\item{labels.cex}{The font size for the axis tick labels.
}

\item{...}{Other arguments pass to \code{\link[circlize]{circos.axis}}.
}
}
\value{
Object \linkS4class{ccGenomicCellGeom}
}
\description{
Object \linkS4class{ccGenomicCellGeom} will call the function \link[circlize:circos.genomicAxis]{circlize::circos.genomicAxis} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(initMode = "initializeWithIdeogram",
chromosome.index = paste0("chr", 1:4), plotType = NULL)
track <- ccTrack(ylim = c(0, 1))
cell <- ccCell(sector.index = "chr1") + ccGenomicAxis()
e <- track + cell
cc + e
}
