% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccGenomicText}
\alias{ccGenomicText}
\title{Add text for genomic data visualization}
\usage{
ccGenomicText(
  region = NULL,
  value = NULL,
  y = NULL,
  labels = NULL,
  labels.column = NULL,
  numeric.column = NULL,
  posTransform = NULL,
  direction = NULL,
  facing = "inside",
  niceFacing = FALSE,
  adj = par("adj"),
  cex = 1,
  col = "black",
  font = par("font"),
  padding = 0,
  extend = 0,
  align_to = "region",
  ...
)
}
\arguments{
\item{region}{A data frame contains 2 column which correspond to start positions and end positions.
}

\item{value}{A data frame contains values and other information.
}

\item{y}{A vector or a single value indicating position of text.
}

\item{labels}{Labels of text corresponding to each genomic positions.
}

\item{labels.column}{If labels are in \code{value}, index of column in \code{value}.
}

\item{numeric.column}{Which column in \code{value} data frame should be taken as y-value.
 If it is not defined, only the first numeric columns in \code{value} will be taken.
}

\item{posTransform}{Self-defined function to transform genomic positions, see \code{\link[circlize]{posTransform.default}} for explanation.
}

\item{direction}{Deprecated, use \code{facing} instead. 
}

\item{facing}{Passing to \code{\link[circlize]{circos.text}}. Settings are similar as \code{col}.
}

\item{niceFacing}{Should the facing of text be adjusted to fit human eyes?
}

\item{adj}{Pass to \code{\link[circlize]{circos.text}}. Settings are similar as \code{col}.
}

\item{cex}{Pass to \code{\link[circlize]{circos.text}}. Settings are similar as \code{col}.
}

\item{col}{Pass to \code{\link[circlize]{circos.text}}. The length of \code{col} can be either one or number of rows of \code{region}.
}

\item{font}{Pass to \code{\link[circlize]{circos.text}}. Settings are similar as \code{col}.
}

\item{padding}{pass to \code{posTransform} if it is set as \code{\link[circlize]{posTransform.text}}.
}

\item{extend}{pass to \code{posTransform} if it is set as \code{\link[circlize]{posTransform.text}}.
}

\item{align_to}{pass to \code{posTransform} if it is set as \code{\link[circlize]{posTransform.text}}.
}

\item{...}{Mysterious parameters.
}
}
\value{
Object \linkS4class{ccGenomicCellGeom}
}
\description{
Object \linkS4class{ccGenomicCellGeom} will call the function \link[circlize:circos.genomicText]{circlize::circos.genomicText} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(initMode = "initializeWithIdeogram", plotType = NULL)
bed <- generateRandomBed(nr = 20)
track1 <- ccGenomicTrack(data = bed, ylim = c(0, 1))
all_chr <- c("chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8",
"chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16",
"chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY")
text1 <- ccGenomicText(y = 0.5, labels = "text")
cells1 <- ccCells(sector.indexes = all_chr) + text1
cc + (track1 + cells1)
}
