% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{ccPar}
\alias{ccPar}
\title{Parameters for the circular layout}
\usage{
ccPar(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[circlize:circos.par]{circlize::circos.par}}
  \describe{
    \item{\code{RESET}}{reset to default values
}
    \item{\code{READ.ONLY}}{please ignore
}
    \item{\code{LOCAL}}{please ignore
}
    \item{\code{ADD}}{please ignore
}
  }}
}
\value{
Object \linkS4class{ccPar}
}
\description{
Object \linkS4class{ccPar} will call the function \link[circlize:circos.par]{circlize::circos.par} while drawing.
}
\examples{
library(circlizePlus)
set.seed(999)
n = 1000
df = data.frame(sectors = sample(letters[1:8], n, replace = TRUE),x = rnorm(n), y = runif(n))
par1 = ccPar("track.height" = 0.1)
cc = ccPlot(initMode = "initialize", sectors = df$sectors, x = df$x)
track1 = ccTrack(df$sectors, y = df$y)
col = rep(c("#FF0000", "#00FF00"), 4)
tPoint1 = ccTrackPoints(df$sectors, df$x, df$y, col = col, pch = 16, cex = 0.5)
cc + par1 + (track1 + tPoint1)
}
