% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\docType{class}
\name{ccPlot-class}
\alias{ccPlot-class}
\title{S4 class ccPlot}
\description{
S4 class ccPlot
}
\section{Slots}{

\describe{
\item{\code{initMode}}{character. It can only be the following values: "initialize", "genomicInitialize", "initializeWithIdeogram", "heatmap.initialize".}

\item{\code{initParams}}{list. A \strong{named} list that stores the parameters of the function called by the backend. Based on the value of initMode, the backend function will be one of the following four:\link[circlize:circos.initialize]{circlize::circos.initialize}, \link[circlize:circos.genomicInitialize]{circlize::circos.genomicInitialize}, \link[circlize:circos.initializeWithIdeogram]{circlize::circos.initializeWithIdeogram}, \link[circlize:circos.heatmap.initialize]{circlize::circos.heatmap.initialize}.}

\item{\code{tracks}}{list. A list where \linkS4class{ccTrack} or \linkS4class{ccGenomicTrack} or \linkS4class{ccHeatmap} are stored.}

\item{\code{links}}{list. A list where \linkS4class{ccLink} or \linkS4class{ccGenomicLink} or \linkS4class{ccHeatmapLink} are stored.}

\item{\code{pars}}{list. A list where \linkS4class{ccPar} are stored.}

\item{\code{clear}}{logical. Whether to call \link[circlize:circos.clear]{circlize::circos.clear} before drawing.}
}}

\examples{
n = 1000
df = data.frame(sectors = sample(letters[1:8], n, replace = TRUE),
                x = rnorm(n), y = runif(n))
library(circlizePlus)
cc=ccPlot(initMode = 'initialize', sectors = df$sectors, x = df$x)
}
