% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{show,ccPlot-method}
\alias{show,ccPlot-method}
\title{Draw the figures described by ccPlot}
\usage{
\S4method{show}{ccPlot}(object)
}
\arguments{
\item{object}{Object of \linkS4class{ccPlot}}
}
\value{
No return information
}
\description{
Draw the figures described by ccPlot
}
\examples{
library(circlizePlus)
n = 1000
df = data.frame(sectors = sample(letters[1:8], n, replace = TRUE),
                x = rnorm(n), y = runif(n))
library(circlizePlus)
par1=ccPar("track.height" = 0.1)
cc=ccPlot(sectors = df$sectors, x = df$x) + par1
track1 = ccTrack(sectors = df$sectors, y = df$y,
                 panel.fun = function(x, y) {
                   circos.text(CELL_META$xcenter,
                               CELL_META$cell.ylim[2] + mm_y(5),
                               CELL_META$sector.index)
                   circos.axis(labels.cex = 0.6)
                 })
cc=cc+track1
show(cc)
}
