% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnn.R
\name{transfer}
\alias{transfer}
\title{Transfer learning}
\usage{
transfer(
  name = c("alexnet", "inception_v3", "mobilenet_v2", "resnet101", "resnet152",
    "resnet18", "resnet34", "resnet50", "resnext101_32x8d", "resnext50_32x4d", "vgg11",
    "vgg11_bn", "vgg13", "vgg13_bn", "vgg16", "vgg16_bn", "vgg19", "vgg19_bn",
    "wide_resnet101_2", "wide_resnet50_2"),
  pretrained = TRUE,
  freeze = TRUE
)
}
\arguments{
\item{name}{The name of the pretrained model}

\item{pretrained}{if FALSE, random weights are used instead of the pretrained weights}

\item{freeze}{if TRUE, the weights of the pretrained model (except the "classifier" part at the end) aren't changed in the training anymore. Only works if pretrained=TRUE}
}
\value{
S3 object of class \code{"transfer" "citolayer"}
}
\description{
creates a 'transfer' 'citolayer' object that is used by \code{\link{create_architecture}}.
}
\details{
This function creates a 'transfer' 'citolayer' object that is passed to the \code{\link{create_architecture}} function.
With this object the pretrained models that are available in the 'torchvision' package can be used in cito.
When 'freeze' is set to TRUE, only the weights of the last part of the network (consisting of one or more linear layers) are adjusted in the training.
There mustn't be any other citolayers before the transfer citolayer object when calling \code{\link{create_architecture}}.
If there are any citolayers after the transfer citolayer, the linear classifier part of the pretrained model is replaced with the specified citolayers.
}
\seealso{
\code{\link{create_architecture}}
}
\author{
Armin Schenk
}
