% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment}
\alias{segment}
\title{Segment Function}
\usage{
segment(
  data,
  modeltype = c("tree", "k-clusters"),
  FUN = NULL,
  FUN_preprocess = NULL,
  steps = c("preprocess", "model"),
  prettify = FALSE,
  print_plot = FALSE,
  hyperparameters = NULL,
  force = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{data.frame, the data to segment}

\item{modeltype}{character, the type of model to use to segment choices are: 'tree', 'k-clusters'}

\item{FUN}{function, A user specified function to segment, if the standard methods are not wanting to be used}

\item{FUN_preprocess}{function, A user specified function to preprocess, if the standard methods are not wanting to be used}

\item{steps}{list, names of the steps the user want to run the data on. Options are 'preprocess' and 'model'}

\item{prettify}{logical, TRUE if want cleaned up outputs, FALSE for raw output}

\item{print_plot}{logical, TRUE if want to print the plot}

\item{hyperparameters}{list of hyperparameters to use in the model.}

\item{force}{logical, TRUE to ignore errors in validation step and force model execution.}

\item{verbose}{logical whether information about the segmentation pipeline should be given.}
}
\value{
A list of three objects. A tibble providing high-level segment attributes, a lookup table (data frame)
with the id and predicted segment number, and an rpart object defining the model.
}
\description{
Segments the data by running all steps in the segmentation pipeline, including output table
}
