% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_segment.R
\name{tree_segment}
\alias{tree_segment}
\title{Tree Segment Function}
\usage{
tree_segment(data, hyperparameters, verbose = TRUE)
}
\arguments{
\item{data}{data.frame, the data to segment}

\item{hyperparameters}{list, list of hyperparameters to pass. They include
segmentation_variables: a vector or list with variable names that will be used as segmentation variables; 
dependent_variable: a string with the name of the dependent variable that is used in the clustering;
min_segmentation_fraction: integer, the minimum segment size as a proportion of the total data set;
number_of_segments: integer, number of leaves you want the decision tree to have.}

\item{verbose}{logical whether information about the segmentation procedure should be given.}
}
\value{
List of 4 objects. The rpart object defining the model, a data frame providing high-level segment attributes,
a lookup table (data frame) with the id and predicted segment number, and a list of the hyperparameters used.
}
\description{
Runs decision tree optimisation on the data to segment ids.
}
\author{
Stuart Davie, \email{stuart.davie@peak.ai}
}
