% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu.plots.R
\name{ciu.explain.long.data.frame}
\alias{ciu.explain.long.data.frame}
\title{Produce CIU explanations as "long" \link{data.frame}}
\usage{
ciu.explain.long.data.frame(CIU, data = NULL, out.ind = 1, neutral.CU = 0.5)
}
\arguments{
\item{CIU}{CIU object, as created by \link{ciu.new}.}

\item{data}{Data to use as \link{data.frame} (default: NULL). If NULL, then use the data of the
CIU object, if that exists. This \link{data.frame} must contain only feature (input)
values, not output value(s).}

\item{out.ind}{Index of output to explain. Default: 1.}

\item{neutral.CU}{Neutral CU value(s). Default is 0.5.}
}
\value{
\link{data.frame} of class "ciu.result.long.data.frame".
}
\description{
This function takes a CIU object and calculates CIU values for the whole data
set given as parameter to \link{ciu.new} or given as the \code{data} parameter.
}
\examples{
\dontrun{
# Boston data set with GBM model.
library(MASS)
library(caret)
kfoldcv <- trainControl(method="cv", number=10)
gbm <- caret::train(medv ~ ., Boston, method="gbm", trControl=kfoldcv)
ciu <- ciu.new(gbm, medv~., Boston)
df <- ciu.explain.long.data.frame(ciu)
head(df)
# Only get results for a part of the data set.
ciu.explain.long.data.frame(ciu, data=subset(Boston[1:10,], select=-medv))
}
}
