% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acX_to_rho.R
\name{acX_to_rho}
\alias{acX_to_rho}
\title{Computes the known correlation \eqn{\rho}
between  \eqn{\widehat{\theta}} and \eqn{\widehat{\tau}} from the
\eqn{p}-vectors
\eqn{a} and \eqn{c} and the
design matrix \eqn{X}}
\usage{
acX_to_rho(a, c, X)
}
\arguments{
\item{a}{The \eqn{p}-vector \eqn{a} that specifies the parameter of interest
\eqn{\theta =a^{\top}\beta}}

\item{c}{The \eqn{p}-vector \eqn{c} used in the specification of the parameter
\eqn{\tau=c^{\top} \beta-t}. The uncertain prior
information is that \eqn{\tau=0}}

\item{X}{The \eqn{n \times p} design matrix \eqn{X}, with linearly
independent columns}
}
\value{
The known correlation \eqn{\rho} between \eqn{\widehat{\theta}}
and \eqn{\widehat{\tau}}.
}
\description{
Computes the known correlation \eqn{\rho}
between  \eqn{\widehat{\theta}}
and \eqn{\widehat{\tau}}. This correlation is computed from the
\eqn{p}-vectors
\eqn{a} and \eqn{c} and the \eqn{n \times p}
design matrix \eqn{X}, with linearly independent columns, using the formula
\eqn{\rho=a^{\top}(X^{\top} X)^{-1} c
/(v_{\theta} \, v_{\tau})^{1/2}}, where
\eqn{v_{\theta}
=a^{\top}(X^{\top} X)^{-1}a} and
\eqn{v_{\tau}
=c^{\top}(X^{\top} X)^{-1}c}.
}
\examples{
a <- c(0, 2, 0, -2)
c <- c(0, 0, 0, 1)
x1 <- c(-1, 1, -1, 1)
x2 <- c(-1, -1, 1, 1)
X <- cbind(rep(1, 4), x1, x2, x1*x2)
rho <- acX_to_rho(a, c, X)
print(rho)

}
