% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_list_kubernetes_instance_configs_historical_metrics}
\alias{clusters_list_kubernetes_instance_configs_historical_metrics}
\title{Get graphs of historical resource usage in an Instance Config}
\usage{
clusters_list_kubernetes_instance_configs_historical_metrics(
  instance_config_id,
  timeframe = NULL,
  metric = NULL
)
}
\arguments{
\item{instance_config_id}{integer required. The ID of this instance config.}

\item{timeframe}{string optional. The span of time that the graphs cover. Must be one of 1_day, 1_week.}

\item{metric}{string optional. The metric to retrieve. Must be one of cpu, memory.}
}
\value{
A list containing the following elements:
\item{instanceConfigId}{integer, The ID of this instance config.}
\item{metric}{string, URL for the graph of historical CPU usage in this instance config.}
\item{timeframe}{string, The span of time that the graphs cover. Must be one of 1_day, 1_week.}
\item{unit}{string, The unit of the values.}
\item{metrics}{list, A list containing the following elements: 
\itemize{
\item used list . A list containing the following elements: 
\itemize{
\item times array, The times associated with data points, in seconds since epoch.
\item values array, The values of the data points.
}
\item requested list . A list containing the following elements: 
\itemize{
\item times array, The times associated with data points, in seconds since epoch.
\item values array, The values of the data points.
}
\item capacity list . A list containing the following elements: 
\itemize{
\item times array, The times associated with data points, in seconds since epoch.
\item values array, The values of the data points.
}
}}
}
\description{
Get graphs of historical resource usage in an Instance Config
}
