% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_patch.R
\name{package_patch}
\alias{package_patch}
\title{Update a package's metadata}
\usage{
package_patch(
  x,
  id = NULL,
  extras = NULL,
  http_method = "GET",
  key = get_default_key(),
  url = get_default_url(),
  as = "list",
  ...
)
}
\arguments{
\item{x}{(list) A list with key-value pairs}

\item{id}{(character) Resource ID to update (optional, required if
x does not have an "id" field)}

\item{extras}{(character vector) - the dataset's extras
(optional), extras are arbitrary (key: value) metadata items that can be
added to datasets, each extra dictionary should have keys 'key' (a string),
'value' (a string)}

\item{http_method}{(character) which HTTP method (verb) to use; one of
"GET" or "POST". Default: "GET"}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Update a package's metadata
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org", key = getOption("ckan_demo_key"))

# Create a package
(res <- package_create("hello-world13", author="Jane Doe"))

# Get a resource
res <- package_show(res$id)
res$title

# patch
package_patch(res, extras = list(list(key = "foo", value = "bar")))
unclass(package_show(res))
}
}
