% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_show.R
\name{user_show}
\alias{user_show}
\title{Show a user.}
\usage{
user_show(
  id,
  user_obj = NULL,
  include_datasets = FALSE,
  include_num_followers = FALSE,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{id}{(character) Package identifier.}

\item{user_obj}{(user dictionary) The user dictionary of the user (optional)}

\item{include_datasets}{(logical) Include a list of datasets the user has
created. If it is the same user or a sysadmin requesting, it includes
datasets that are draft or private. (optional, default:False, limit:50)}

\item{include_num_followers}{(logical) Include the number of followers
the user has (optional, default:False)}

\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Show a user.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# show user
user_show('sckottie')

# include datasets
user_show('sckottie', include_datasets = TRUE)

# include datasets
user_show('sckottie', include_num_followers = TRUE)
}
}
